/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.taxes;

import io.github.lightman314.lightmanscurrency.api.taxes.ITaxCollector;
import io.github.lightman314.lightmanscurrency.api.taxes.ITaxable;
import io.github.lightman314.lightmanscurrency.api.taxes.reference.TaxReferenceType;
import io.github.lightman314.lightmanscurrency.common.impl.TaxAPIImpl;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TaxAPI {
    private static TaxAPI instance;

    public static TaxAPI getApi() {
        if (instance == null) {
            instance = new TaxAPIImpl();
        }
        return instance;
    }

    protected TaxAPI() {
        if (instance != null) {
            throw new IllegalCallerException("Cannot create a new TaxAPI instance as one is already present!");
        }
    }

    public abstract void RegisterReferenceType(TaxReferenceType var1);

    @Nullable
    public abstract TaxReferenceType GetReferenceType(ResourceLocation var1);

    @Nullable
    public final ITaxCollector GetTaxCollector(IClientTracker context, long collectorID) {
        return this.GetTaxCollector(context.isClient(), collectorID);
    }

    @Nullable
    public abstract ITaxCollector GetTaxCollector(boolean var1, long var2);

    @Nullable
    public final ITaxCollector GetServerTaxCollector(IClientTracker context) {
        return this.GetServerTaxCollector(context.isClient());
    }

    public abstract ITaxCollector GetServerTaxCollector(boolean var1);

    public abstract List<ITaxCollector> GetTaxCollectorsFor(ITaxable var1);

    public abstract List<ITaxCollector> GetPotentialTaxCollectorsFor(ITaxable var1);

    public abstract List<ITaxCollector> AcknowledgeTaxCollectors(ITaxable var1);
}

