/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.trader_interface.blocks;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.ejection.SafeEjectionAPI;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.QuarantineAPI;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IEasyEntityBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.RotatableBlock;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeableBlock;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class TraderInterfaceBlock
extends RotatableBlock
implements IEasyEntityBlock,
IOwnableBlock,
IUpgradeableBlock {
    protected TraderInterfaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult result) {
        if (!level.f_46443_) {
            if (QuarantineAPI.IsDimensionQuarantined(level)) {
                EasyText.sendMessage(player, (Component)LCText.MESSAGE_DIMENSION_QUARANTINED_TERMINAL.getWithStyle(ChatFormatting.GOLD));
            } else {
                TraderInterfaceBlockEntity blockEntity = this.getBlockEntity((LevelAccessor)level, pos, state);
                if (blockEntity != null) {
                    BlockEntityUtil.sendUpdatePacket(blockEntity);
                    blockEntity.openMenu(player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity player, @Nonnull ItemStack stack) {
        TraderInterfaceBlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = this.getBlockEntity((LevelAccessor)level, pos, state)) != null) {
            blockEntity.initOwner((Entity)player);
        }
    }

    public void m_5707_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        TraderInterfaceBlockEntity blockEntity = this.getBlockEntity((LevelAccessor)level, pos, state);
        if (blockEntity != null) {
            if (!blockEntity.isOwner(player)) {
                return;
            }
            InventoryUtil.dumpContents(level, pos, blockEntity.getContents(level, pos, state, !player.m_7500_()));
            blockEntity.flagAsRemovable();
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean flag) {
        TraderInterfaceBlockEntity blockEntity;
        if (state.m_60734_() == newState.m_60734_()) {
            return;
        }
        if (!level.f_46443_ && (blockEntity = this.getBlockEntity((LevelAccessor)level, pos, state)) != null) {
            if (!blockEntity.allowRemoval()) {
                LightmansCurrency.LogError("Trader block at " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_() + " was broken by illegal means!");
                LightmansCurrency.LogError("Activating emergency eject protocol.");
                EjectionData data = blockEntity.buildEjectionData(level, pos, state);
                SafeEjectionAPI.getApi().handleEjection(level, pos, data);
                blockEntity.flagAsRemovable();
                try {
                    this.onInvalidRemoval(state, level, pos, blockEntity);
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Error during trader interface remove call", t);
                }
            } else {
                LightmansCurrency.LogInfo("Trader block was broken by legal means!");
            }
        }
        super.m_6810_(state, level, pos, newState, flag);
    }

    protected abstract void onInvalidRemoval(BlockState var1, Level var2, BlockPos var3, TraderInterfaceBlockEntity var4);

    @Override
    public boolean canBreak(@Nonnull Player player, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        TraderInterfaceBlockEntity be = this.getBlockEntity(level, pos, state);
        if (be == null) {
            return true;
        }
        return be.isOwner(player);
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return this.createBlockEntity(pos, state);
    }

    protected abstract BlockEntity createBlockEntity(BlockPos var1, BlockState var2);

    protected abstract BlockEntityType<?> interfaceType();

    @Override
    @Nonnull
    public Collection<BlockEntityType<?>> getAllowedTypes() {
        return ImmutableList.of(this.interfaceType());
    }

    protected final TraderInterfaceBlockEntity getBlockEntity(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof TraderInterfaceBlockEntity) {
            TraderInterfaceBlockEntity tibe = (TraderInterfaceBlockEntity)be;
            return tibe;
        }
        return null;
    }

    protected Supplier<List<Component>> getItemTooltips() {
        return ArrayList::new;
    }

    @Override
    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        TooltipItem.addTooltip(tooltip, this.getItemTooltips());
        super.m_5871_(stack, level, tooltip, flagIn);
    }

    public boolean m_7899_(@Nonnull BlockState state) {
        return true;
    }

    public ItemStack getDropBlockItem(BlockState state, TraderInterfaceBlockEntity traderInterface) {
        return new ItemStack((ItemLike)state.m_60734_());
    }

    @Override
    public boolean canUseUpgradeItem(@Nonnull IUpgradeable upgradeable, @Nonnull ItemStack stack, @Nullable Player player) {
        if (player != null && upgradeable instanceof TraderInterfaceBlockEntity) {
            TraderInterfaceBlockEntity be = (TraderInterfaceBlockEntity)upgradeable;
            return be.owner.isMember(player);
        }
        return false;
    }
}

