/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders;

import com.google.common.collect.ImmutableMap;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.MoneyHolder;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.MultiMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.ticket.TicketCollectionResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.discount_codes.CouponSource;
import io.github.lightman314.lightmanscurrency.api.traders.discount_codes.IDiscountCodeSource;
import io.github.lightman314.lightmanscurrency.common.blockentity.handler.ICanCopy;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.InteractionSlot;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.ItemRequirement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TradeContext {
    private static long nextID = 0L;
    public final long id = nextID++;
    public final boolean isStorageMode;
    private final TraderData trader;
    @Nullable
    private final Player player;
    private final PlayerReference playerReference;
    private final MultiMoneyHolder moneyHolders;
    private final List<IDiscountCodeSource> discountCodeSources;
    private final InteractionSlot interactionSlot;
    private final IItemHandler itemHandler;
    private final IFluidHandler fluidTank;
    private final IEnergyStorage energyTank;
    private final Map<ResourceLocation, Object> customData;

    public boolean hasTrader() {
        return this.trader != null;
    }

    public TraderData getTrader() {
        return this.trader;
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public boolean hasPlayerReference() {
        return this.playerReference != null;
    }

    public final PlayerReference getPlayerReference() {
        return this.playerReference;
    }

    public Set<Integer> getDiscountCodes() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (IDiscountCodeSource source : this.discountCodeSources) {
            set.addAll(source.getDiscountCodes());
        }
        return set;
    }

    public boolean hasDiscountCode(String code) {
        for (IDiscountCodeSource source : this.discountCodeSources) {
            if (!source.containsCode(code)) continue;
            return true;
        }
        return false;
    }

    public void consumeDiscountCode(String code) {
        for (IDiscountCodeSource source : this.discountCodeSources) {
            if (!source.consumeCode(code)) continue;
            return;
        }
    }

    private boolean hasInteractionSlot(String type) {
        return this.getInteractionSlot(type) != null;
    }

    private InteractionSlot getInteractionSlot(String type) {
        if (this.interactionSlot == null) {
            return null;
        }
        if (this.interactionSlot.isType(type)) {
            return this.interactionSlot;
        }
        return null;
    }

    private boolean hasItemHandler() {
        return this.itemHandler != null;
    }

    private boolean hasFluidTank() {
        return this.fluidTank != null;
    }

    private boolean hasEnergyTank() {
        return this.energyTank != null;
    }

    private TradeContext(Builder builder) {
        this.isStorageMode = builder.storageMode;
        this.trader = builder.trader;
        this.player = builder.player;
        this.moneyHolders = new MultiMoneyHolder(builder.moneyHandlers);
        this.discountCodeSources = builder.discountCodes;
        this.discountCodeSources.sort(Comparator.comparingInt(IDiscountCodeSource::priority).reversed());
        this.playerReference = builder.playerReference;
        this.interactionSlot = builder.interactionSlot;
        this.itemHandler = builder.itemHandler;
        this.fluidTank = builder.fluidHandler;
        this.energyTank = builder.energyHandler;
        this.customData = ImmutableMap.copyOf(builder.customData);
    }

    public boolean hasPaymentMethod() {
        return this.hasPlayer();
    }

    public boolean hasFunds(MoneyValue price) {
        if (price.isFree() || price.isEmpty()) {
            return true;
        }
        return this.getAvailableFunds().containsValue(price);
    }

    public MoneyView getAvailableFunds() {
        return this.moneyHolders.getStoredMoney();
    }

    public List<Component> getAvailableFundsDescription() {
        ArrayList<Component> text = new ArrayList<Component>();
        this.moneyHolders.formatTooltip(text);
        return text;
    }

    public boolean getPayment(MoneyValue price) {
        if (price == null) {
            return false;
        }
        if (price.isFree() || price.isEmpty()) {
            return true;
        }
        if (this.moneyHolders.extractMoney(price, true).isEmpty()) {
            this.moneyHolders.extractMoney(price, false);
            return true;
        }
        return false;
    }

    public boolean givePayment(MoneyValue price) {
        if (price == null) {
            return false;
        }
        if (price.isFree()) {
            return true;
        }
        if (this.moneyHolders.insertMoney(price, true).isEmpty()) {
            this.moneyHolders.insertMoney(price, false);
            return true;
        }
        return false;
    }

    public boolean hasItem(ItemStack item) {
        if (this.hasItemHandler()) {
            return InventoryUtil.CanExtractItem(this.itemHandler, item);
        }
        if (this.hasPlayer()) {
            return InventoryUtil.GetItemCount((Container)this.player.m_150109_(), item) >= item.m_41613_();
        }
        return false;
    }

    public boolean hasItems(ItemStack ... items) {
        for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
            if (this.hasItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean hasItems(List<ItemStack> items) {
        if (items == null) {
            return false;
        }
        for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
            if (this.hasItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean hasItems(ItemRequirement ... requirements) {
        if (this.hasItemHandler()) {
            return ItemRequirement.getFirstItemsMatchingRequirements(this.itemHandler, requirements) != null;
        }
        if (this.hasPlayer()) {
            return ItemRequirement.getFirstItemsMatchingRequirements((Container)this.player.m_150109_(), requirements) != null;
        }
        return false;
    }

    public boolean hasTicket(long ticketID) {
        block3: {
            block2: {
                if (!this.hasItemHandler()) break block2;
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    long id;
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (!TicketItem.isTicket(stack) && !TicketItem.isPass(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                    ItemStack copyStack = stack.m_41777_();
                    copyStack.m_41764_(1);
                    if (!InventoryUtil.CanExtractItem(this.itemHandler, copyStack)) continue;
                    return true;
                }
                break block3;
            }
            if (!this.hasPlayer()) break block3;
            Inventory inventory = this.player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                long id;
                ItemStack stack = inventory.m_8020_(i);
                if (!TicketItem.isTicket(stack) && !TicketItem.isPass(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated(since="2.2.6.3")
    public boolean hasPass(long ticketID) {
        block3: {
            block2: {
                if (!this.hasItemHandler()) break block2;
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    long id;
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (!TicketItem.isPass(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                    return true;
                }
                break block3;
            }
            if (!this.hasPlayer()) break block3;
            Inventory inventory = this.player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                long id;
                ItemStack stack = inventory.m_8020_(i);
                if (!TicketItem.isPass(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasInfinitePass(long ticketID) {
        block3: {
            block2: {
                if (!this.hasItemHandler()) break block2;
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    long id;
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (!TicketItem.isInfinitePass(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                    return true;
                }
                break block3;
            }
            if (!this.hasPlayer()) break block3;
            Inventory inventory = this.player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                long id;
                ItemStack stack = inventory.m_8020_(i);
                if (!TicketItem.isInfinitePass(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                return true;
            }
        }
        return false;
    }

    public boolean collectItem(ItemStack item) {
        if (this.hasItem(item)) {
            if (this.hasItemHandler()) {
                InventoryUtil.RemoveItemCount(this.itemHandler, item);
                return true;
            }
            if (this.hasPlayer()) {
                InventoryUtil.RemoveItemCount((Container)this.player.m_150109_(), item);
                return true;
            }
        }
        return false;
    }

    public boolean collectItems(List<ItemStack> items) {
        items = InventoryUtil.combineQueryItems(items);
        for (ItemStack item : items) {
            if (this.hasItem(item)) continue;
            return false;
        }
        for (ItemStack item : items) {
            this.collectItem(item);
        }
        return true;
    }

    public List<ItemStack> getCollectableItems(ItemRequirement ... requirements) {
        if (this.hasItemHandler()) {
            return ItemRequirement.getFirstItemsMatchingRequirements(this.itemHandler, requirements);
        }
        if (this.hasPlayer()) {
            return ItemRequirement.getFirstItemsMatchingRequirements((Container)this.player.m_150109_(), requirements);
        }
        return null;
    }

    public void hightlightItems(List<ItemRequirement> requirements, List<Slot> slots, List<Integer> results) {
        if (this.hasPlayer()) {
            HashMap<Integer, Integer> inventoryConsumedCounts = new HashMap<Integer, Integer>();
            Inventory inventory = this.player.m_150109_();
            for (ItemRequirement requirement : requirements) {
                int amountToConsume = requirement.getCount();
                for (int i = 0; i < inventory.m_6643_() && amountToConsume > 0; ++i) {
                    ItemStack stack = inventory.m_8020_(i);
                    if (!requirement.test(stack) || stack.m_41619_()) continue;
                    int alreadyConsumed = inventoryConsumedCounts.getOrDefault(i, 0);
                    int consumeCount = Math.min(amountToConsume, stack.m_41613_() - alreadyConsumed);
                    amountToConsume -= consumeCount;
                    if ((alreadyConsumed += consumeCount) <= 0) continue;
                    inventoryConsumedCounts.put(i, alreadyConsumed);
                }
            }
            Iterator<ItemRequirement> iterator = inventoryConsumedCounts.keySet().iterator();
            while (iterator.hasNext()) {
                int relevantSlot = (Integer)((Object)iterator.next());
                for (int i = 0; i < slots.size(); ++i) {
                    Slot slot = slots.get(i);
                    if (slot.f_40218_ != inventory || slot.m_150661_() != relevantSlot) continue;
                    results.add(i);
                }
            }
        }
    }

    public TicketCollectionResult collectTicket(long ticketID) {
        block7: {
            block8: {
                if (!this.hasTicket(ticketID)) break block7;
                if (this.hasInfinitePass(ticketID)) {
                    return TicketCollectionResult.PASS;
                }
                if (!this.hasItemHandler()) break block8;
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    boolean spawnStub;
                    long id;
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (TicketItem.isTicket(stack)) {
                        id = TicketItem.GetTicketID(stack);
                        if (id != ticketID) continue;
                        ItemStack extractStack = stack.m_41777_();
                        extractStack.m_41764_(1);
                        if (!InventoryUtil.RemoveItemCount(this.itemHandler, extractStack)) continue;
                        return TicketCollectionResult.PASS_WITH_STUB;
                    }
                    if (!TicketItem.isPass(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                    ItemStack extra = TicketItem.damageTicket(stack);
                    boolean bl = spawnStub = extra.m_41619_() && stack.m_41619_();
                    if (!extra.m_41619_() && !(extra = ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)extra, (boolean)false)).m_41619_() && this.player != null) {
                        ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)extra);
                    }
                    return TicketCollectionResult.pass(spawnStub);
                }
                break block7;
            }
            if (!this.hasPlayer()) break block7;
            Inventory inventory = this.player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                boolean spawnStub;
                long id;
                ItemStack stack = inventory.m_8020_(i);
                if (TicketItem.isTicket(stack)) {
                    id = TicketItem.GetTicketID(stack);
                    if (id != ticketID) continue;
                    inventory.m_7407_(i, 1);
                    inventory.m_6596_();
                    return TicketCollectionResult.PASS_WITH_STUB;
                }
                if (!TicketItem.isPass(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                ItemStack extra = TicketItem.damageTicket(stack);
                boolean bl = spawnStub = extra.m_41619_() && stack.m_41619_();
                if (!extra.m_41619_()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)extra);
                }
                return TicketCollectionResult.pass(spawnStub);
            }
        }
        return TicketCollectionResult.FAIL;
    }

    public boolean canFitItem(ItemStack item) {
        if (item.m_41619_()) {
            return true;
        }
        if (this.hasItemHandler()) {
            return ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)item, (boolean)true).m_41619_();
        }
        return this.hasPlayer();
    }

    public boolean canFitItems(ItemStack ... items) {
        if (this.hasItemHandler()) {
            IItemHandler copy;
            IItemHandler original = this.itemHandler;
            if (original instanceof ICanCopy) {
                copy = (IItemHandler)((ICanCopy)original).copy();
            } else {
                NonNullList inventory = NonNullList.m_122780_((int)original.getSlots(), (Object)ItemStack.f_41583_);
                for (int i = 0; i < original.getSlots(); ++i) {
                    inventory.set(i, (Object)original.getStackInSlot(i));
                }
                copy = new ItemStackHandler(inventory);
            }
            for (ItemStack item : items) {
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)copy, (ItemStack)item, (boolean)false).m_41619_()) continue;
                return false;
            }
            return true;
        }
        return this.hasPlayer();
    }

    public boolean canFitItems(List<ItemStack> items) {
        if (this.hasItemHandler()) {
            IItemHandler original = this.itemHandler;
            IItemHandler copy = null;
            if (original instanceof ICanCopy) {
                try {
                    copy = (IItemHandler)((ICanCopy)original).copy();
                }
                catch (Throwable t) {
                    LightmansCurrency.LogDebug("Error copying item handler.", t);
                }
            }
            if (copy == null) {
                NonNullList inventory = NonNullList.m_122780_((int)original.getSlots(), (Object)ItemStack.f_41583_);
                for (int i = 0; i < original.getSlots(); ++i) {
                    inventory.set(i, (Object)original.getStackInSlot(i).m_41777_());
                }
                copy = new ItemStackHandler(inventory);
            }
            for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)copy, (ItemStack)item, (boolean)false).m_41619_()) continue;
                return false;
            }
            return true;
        }
        return this.hasPlayer();
    }

    public boolean putItem(ItemStack item) {
        if (this.canFitItem(item)) {
            if (this.hasItemHandler()) {
                ItemStack leftovers = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)item, (boolean)false);
                if (leftovers.m_41619_()) {
                    return true;
                }
                ItemStack placedStack = item.m_41777_();
                placedStack.m_41764_(item.m_41613_() - leftovers.m_41613_());
                if (!item.m_41619_()) {
                    this.collectItem(placedStack);
                }
                return false;
            }
            if (this.hasPlayer()) {
                ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)item);
                return true;
            }
        }
        return false;
    }

    public boolean hasFluid(FluidStack fluid) {
        if (this.hasFluidTank()) {
            FluidStack result = this.fluidTank.drain(fluid, IFluidHandler.FluidAction.SIMULATE);
            return !result.isEmpty() && result.getAmount() >= fluid.getAmount();
        }
        if (this.hasInteractionSlot("BUCKET_SLOT")) {
            ItemStack bucketStack = this.getInteractionSlot("BUCKET_SLOT").m_7993_();
            AtomicBoolean hasFluid = new AtomicBoolean(false);
            FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> {
                FluidStack result = fluidHandler.drain(fluid, IFluidHandler.FluidAction.SIMULATE);
                hasFluid.set(!result.isEmpty() && result.getAmount() == fluid.getAmount());
            });
            return hasFluid.get();
        }
        return false;
    }

    public boolean drainFluid(FluidStack fluid) {
        if (this.hasFluid(fluid)) {
            if (this.hasFluidTank()) {
                this.fluidTank.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
            if (this.hasInteractionSlot("BUCKET_SLOT")) {
                InteractionSlot slot = this.getInteractionSlot("BUCKET_SLOT");
                ItemStack bucketStack = slot.m_7993_();
                FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> {
                    fluidHandler.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
                    slot.m_5852_(fluidHandler.getContainer());
                });
                return true;
            }
        }
        return false;
    }

    public boolean canFitFluid(FluidStack fluid) {
        if (this.hasFluidTank()) {
            return this.fluidTank.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount();
        }
        if (this.hasInteractionSlot("BUCKET_SLOT")) {
            ItemStack bucketStack = this.getInteractionSlot("BUCKET_SLOT").m_7993_();
            AtomicBoolean fitFluid = new AtomicBoolean(false);
            FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> fitFluid.set(fluidHandler.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount()));
            return fitFluid.get();
        }
        return false;
    }

    public boolean fillFluid(FluidStack fluid) {
        if (this.canFitFluid(fluid)) {
            if (this.hasFluidTank()) {
                this.fluidTank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
            if (this.hasInteractionSlot("BUCKET_SLOT")) {
                InteractionSlot slot = this.getInteractionSlot("BUCKET_SLOT");
                ItemStack bucketStack = slot.m_7993_();
                FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> {
                    fluidHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                    slot.m_5852_(fluidHandler.getContainer());
                });
            }
        }
        return false;
    }

    public boolean hasEnergy(int amount) {
        if (this.hasEnergyTank()) {
            return this.energyTank.extractEnergy(amount, true) == amount;
        }
        if (this.hasInteractionSlot("ENERGY_SLOT")) {
            ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").m_7993_();
            boolean hasEnergy = false;
            IEnergyStorage energyHandler = (IEnergyStorage)batteryStack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
            if (energyHandler != null) {
                return energyHandler.extractEnergy(amount, true) == amount;
            }
            return false;
        }
        return false;
    }

    public boolean drainEnergy(int amount) {
        if (this.hasEnergy(amount)) {
            if (this.hasEnergyTank()) {
                this.energyTank.extractEnergy(amount, false);
                return true;
            }
            if (this.hasInteractionSlot("ENERGY_SLOT")) {
                ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").m_7993_();
                IEnergyStorage energyHandler = (IEnergyStorage)batteryStack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
                if (energyHandler != null) {
                    energyHandler.extractEnergy(amount, false);
                }
                return true;
            }
        }
        return false;
    }

    public boolean canFitEnergy(int amount) {
        if (this.hasEnergyTank()) {
            return this.energyTank.receiveEnergy(amount, true) == amount;
        }
        if (this.hasInteractionSlot("ENERGY_SLOT")) {
            ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").m_7993_();
            IEnergyStorage energyHandler = (IEnergyStorage)batteryStack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
            if (energyHandler != null) {
                return energyHandler.receiveEnergy(amount, true) == amount;
            }
            return false;
        }
        return false;
    }

    public boolean fillEnergy(int amount) {
        if (this.canFitEnergy(amount)) {
            if (this.hasEnergyTank()) {
                this.energyTank.receiveEnergy(amount, false);
                return true;
            }
            if (this.hasInteractionSlot("ENERGY_SLOT")) {
                ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").m_7993_();
                IEnergyStorage energyHandler = (IEnergyStorage)batteryStack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
                if (energyHandler != null) {
                    energyHandler.receiveEnergy(amount, false);
                }
                return true;
            }
        }
        return false;
    }

    public boolean hasCustomData(ResourceLocation key) {
        return this.customData.containsKey(key);
    }

    @Nullable
    public Object getCustomData(ResourceLocation key) {
        return this.customData.get(key);
    }

    public static TradeContext createStorageMode(TraderData trader) {
        return new Builder(trader).build();
    }

    public static Builder create(TraderData trader, Player player) {
        return new Builder(trader, player, true);
    }

    public static Builder create(TraderData trader, PlayerReference player) {
        return new Builder(trader, player);
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder {
        private final boolean storageMode;
        private final TraderData trader;
        @Nullable
        private final Player player;
        @Nullable
        private final PlayerReference playerReference;
        private final List<IMoneyHolder> moneyHandlers = new ArrayList<IMoneyHolder>();
        private final List<IDiscountCodeSource> discountCodes = new ArrayList<IDiscountCodeSource>();
        @Nullable
        private InteractionSlot interactionSlot;
        @Nullable
        private IItemHandler itemHandler;
        @Nullable
        private IFluidHandler fluidHandler;
        @Nullable
        private IEnergyStorage energyHandler;
        private final Map<ResourceLocation, Object> customData = new HashMap<ResourceLocation, Object>();

        private Builder(TraderData trader) {
            this.storageMode = true;
            this.trader = trader;
            this.player = null;
            this.playerReference = null;
        }

        private Builder(TraderData trader, @Nullable Player player, boolean playerInteractable) {
            this.trader = trader;
            this.player = player;
            if (this.player != null) {
                this.withDiscountCodes((Container)this.player.m_150109_(), s -> ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)s));
            }
            this.playerReference = PlayerReference.of(player);
            this.storageMode = false;
            if (playerInteractable) {
                this.withMoneyHolder(MoneyAPI.getApi().GetPlayersMoneyHandler(player));
            }
        }

        private Builder(TraderData trader, @Nullable PlayerReference player) {
            this.trader = trader;
            this.playerReference = player;
            this.player = null;
            this.storageMode = false;
        }

        public Builder withDiscountCodes(Container container, Consumer<ItemStack> overflowHandler) {
            return this.withDiscountCodes(new CouponSource(container, overflowHandler));
        }

        public Builder withDiscountCodes(IDiscountCodeSource codeSource) {
            this.discountCodes.add(codeSource);
            return this;
        }

        public Builder withBankAccount(@Nullable BankReference bankAccount) {
            if (bankAccount == null) {
                return this;
            }
            return this.withMoneyHolder(bankAccount);
        }

        public Builder withCoinSlots(Container coinSlots) {
            if (this.player == null) {
                return this;
            }
            return this.withMoneyHandler(MoneyAPI.getApi().GetContainersMoneyHandler(coinSlots, this.player), (Component)LCText.TOOLTIP_MONEY_SOURCE_SLOTS.get(new Object[0]), 100);
        }

        public Builder withMoneyHandler(IMoneyHandler moneyHandler, Component title, int priority) {
            return this.withMoneyHolder(MoneyHolder.createFromHandler(moneyHandler, title, priority));
        }

        public Builder withMoneyHolder(IMoneyHolder moneyHandler) {
            if (!this.moneyHandlers.contains(moneyHandler)) {
                this.moneyHandlers.add(moneyHandler);
            }
            return this;
        }

        public Builder withInteractionSlot(InteractionSlot interactionSlot) {
            this.interactionSlot = interactionSlot;
            return this;
        }

        public Builder withItemHandler(IItemHandler itemHandler) {
            this.itemHandler = itemHandler;
            return this;
        }

        public Builder withFluidHandler(IFluidHandler fluidHandler) {
            this.fluidHandler = fluidHandler;
            return this;
        }

        public Builder withEnergyHandler(IEnergyStorage energyHandler) {
            this.energyHandler = energyHandler;
            return this;
        }

        public Builder withCustomData(ResourceLocation key, Object customData) {
            this.customData.put(key, customData);
            return this;
        }

        public TradeContext build() {
            return new TradeContext(this);
        }
    }
}

