/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.blocks;

import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.LazyShapes;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class TraderBlockTallRotatable
extends TraderBlockRotatable
implements ITallBlock {
    private final BiFunction<Direction, Boolean, VoxelShape> shape;

    protected TraderBlockTallRotatable(BlockBehaviour.Properties properties) {
        this(properties, LazyShapes.TALL_BOX_SHAPE);
    }

    protected TraderBlockTallRotatable(BlockBehaviour.Properties properties, VoxelShape shape) {
        this(properties, LazyShapes.lazyTallSingleShape(shape));
    }

    protected TraderBlockTallRotatable(BlockBehaviour.Properties properties, BiFunction<Direction, Boolean, VoxelShape> shape) {
        super(properties.m_278166_(PushReaction.BLOCK));
        this.shape = shape;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected boolean shouldMakeTrader(BlockState state) {
        return this.getIsBottom(state);
    }

    @Override
    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.shape.apply(this.getFacing(state), this.getIsBottom(state));
    }

    @Override
    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ISBOTTOM});
    }

    @Override
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity player, @Nonnull ItemStack stack) {
        if (this.isReplaceable(level, pos.m_7494_())) {
            level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
        } else {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TraderBlockEntity) {
                TraderBlockEntity be = (TraderBlockEntity)blockEntity;
                be.flagAsLegitBreak();
            }
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            if (player instanceof Player) {
                Player p = (Player)player;
                ItemStack giveStack = stack.m_41777_();
                giveStack.m_41764_(1);
                InventoryUtil.safeGiveToPlayer(p.m_150109_(), giveStack);
            }
        }
        this.setPlacedByBase(level, pos, state, player, stack);
    }

    @Deprecated
    public boolean getReplacable(Level level, BlockPos pos, BlockState ignored, LivingEntity player, ItemStack stack) {
        return level.m_8055_(pos).m_60734_() == Blocks.f_50016_;
    }

    @Override
    public void m_5707_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        TraderBlockEntity trader;
        this.playerWillDestroyBase(level, pos, state, player);
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof TraderBlockEntity && !(trader = (TraderBlockEntity)blockEntity).canBreak(player)) {
            return;
        }
        this.setAir(level, this.getOtherHeight(pos, state), player);
    }

    @Override
    public void removeOtherBlocks(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos) {
        this.setAir(level, this.getOtherHeight(pos, state), null);
    }
}

