/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.mojang.blaze3d.platform.InputConstants;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.menus.PlayerTradeMenu;
import io.github.lightman314.lightmanscurrency.network.message.playertrading.CPacketPlayerTradeInteraction;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PlayerTradeScreen
extends EasyMenuScreen<PlayerTradeMenu>
implements IScrollable {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/container/player_trading.png");
    public static final ResourceLocation GUI_CHAT_TEXTURE = VersionUtil.lcResource("textures/gui/container/player_trading_chat.png");
    public static final ResourceLocation GUI_MONEY_TEXTURE = VersionUtil.lcResource("textures/gui/container/player_trading_money.png");
    private int scroll = 0;
    private static final int CHAT_ROWS = 11;
    private static final int CHAT_SIZE = 10;
    private MoneyValueWidget valueInput;
    private EasyButton buttonPropose;
    private EasyButton buttonAccept;
    private IconButton buttonToggleMoneyMode;
    private boolean moneyMode = false;
    private IconButton buttonToggleChat;
    private boolean chatWarning = false;
    private EditBox chatBox;
    private boolean chatMode = false;
    private ScrollListener chatScrollListener;
    private final List<FormattedCharSequence> chatHistory = new ArrayList<FormattedCharSequence>();

    private void setShaderColorForState(@Nonnull EasyGuiGraphics gui, int state) {
        switch (state) {
            case 1: {
                gui.setColor(0.0f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                gui.setColor(0.0f, 1.0f, 0.0f);
                break;
            }
            default: {
                gui.setColor(0.54509807f, 0.54509807f, 0.54509807f);
            }
        }
    }

    public PlayerTradeScreen(PlayerTradeMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.resize(176, 222);
        ((PlayerTradeMenu)this.f_97732_).setChatReceiver(this::receiveChat);
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.resetColor();
        if (this.chatMode) {
            gui.renderNormalBackground(GUI_CHAT_TEXTURE, this);
            int yPos = 106;
            for (int i = this.scroll; i < 11 + this.scroll && i < this.chatHistory.size(); ++i) {
                gui.drawString(this.chatHistory.get(i), 7, yPos, 0x404040);
                yPos -= 10;
            }
        } else {
            if (this.moneyMode) {
                gui.renderNormalBackground(GUI_MONEY_TEXTURE, this);
            } else {
                gui.renderNormalBackground(GUI_TEXTURE, this);
                this.setShaderColorForState(gui, ((PlayerTradeMenu)this.f_97732_).myState());
                gui.blit(GUI_TEXTURE, 77, 50, this.getXSize(), 0, 22, 15);
                this.setShaderColorForState(gui, ((PlayerTradeMenu)this.f_97732_).otherState());
                gui.blit(GUI_TEXTURE, 77, 65, this.getXSize(), 15, 22, 15);
                gui.resetColor();
            }
            Component leftName = ((PlayerTradeMenu)this.f_97732_).isHost() ? ((PlayerTradeMenu)this.f_97732_).getTradeData().getHostName() : ((PlayerTradeMenu)this.f_97732_).getTradeData().getGuestName();
            Component rightName = ((PlayerTradeMenu)this.f_97732_).isHost() ? ((PlayerTradeMenu)this.f_97732_).getTradeData().getGuestName() : ((PlayerTradeMenu)this.f_97732_).getTradeData().getHostName();
            gui.drawString(leftName, 8, 6, 0x404040);
            gui.drawString(rightName, this.getXSize() - 8 - this.f_96547_.m_92852_((FormattedText)rightName), 6, 0x404040);
            leftName = ((PlayerTradeMenu)this.f_97732_).isHost() ? ((PlayerTradeMenu)this.f_97732_).getTradeData().getHostMoney().getText() : ((PlayerTradeMenu)this.f_97732_).getTradeData().getGuestMoney().getText();
            rightName = ((PlayerTradeMenu)this.f_97732_).isHost() ? ((PlayerTradeMenu)this.f_97732_).getTradeData().getGuestMoney().getText() : ((PlayerTradeMenu)this.f_97732_).getTradeData().getHostMoney().getText();
            gui.drawString(leftName, 8, 16, 0x404040);
            gui.drawString(rightName, this.getXSize() - 8 - this.f_96547_.m_92852_((FormattedText)rightName), 16, 0x404040);
        }
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.valueInput = this.addChild(((MoneyValueWidget.Builder)MoneyValueWidget.builder().position(screenArea.pos.offset(0, 30))).old(this.valueInput).valueHandler(this::onValueChanged).blockFreeInputs().build());
        this.valueInput.setVisible(false);
        this.buttonPropose = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(8, 110))).width(70)).text(LCText.BUTTON_PLAYER_TRADING_PROPOSE).pressAction(this::OnPropose)).build());
        this.buttonAccept = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(98, 110))).width(70)).text(LCText.BUTTON_PLAYER_TRADING_ACCEPT).pressAction(this::OnAccept)).build());
        this.buttonAccept.f_93623_ = false;
        this.buttonToggleMoneyMode = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width, 20))).pressAction(this::ToggleMoneyMode)).icon(this::getToggleMoneyIcon).addon(EasyAddonHelper.activeCheck(() -> !this.chatMode))).addon(EasyAddonHelper.tooltip(this::getToggleMoneyTooltip))).build());
        this.buttonToggleChat = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width, 0))).pressAction(this::ToggleChatMode)).icon(this::getToggleIcon).color(() -> this.chatWarning ? 0xFFFF00 : 0xFFFFFF).addon(EasyAddonHelper.tooltip(this::getToggleTooltip))).build());
        this.chatBox = this.addChild(new EditBox(this.f_96547_, screenArea.pos.x + 9, screenArea.pos.y + 120, screenArea.width - 22, 12, (Component)EasyText.empty()));
        this.chatBox.m_94182_(false);
        this.chatBox.m_94199_(256);
        this.chatScrollListener = this.addChild(((ScrollListener.Builder)ScrollListener.builder().area(screenArea.ofSize(screenArea.width, 118))).listener(this).invert().build());
        this.validateWidgetStates();
    }

    @Override
    protected void screenTick() {
        int myState = ((PlayerTradeMenu)this.f_97732_).myState();
        int otherState = ((PlayerTradeMenu)this.f_97732_).otherState();
        this.valueInput.f_93623_ = myState < 1;
        this.buttonPropose.f_93623_ = myState < 2;
        this.buttonPropose.m_93666_((Component)(myState <= 0 ? LCText.BUTTON_PLAYER_TRADING_PROPOSE.get(new Object[0]) : LCText.BUTTON_PLAYER_TRADING_CANCEL.get(new Object[0])));
        this.buttonAccept.f_93623_ = myState > 0 && otherState > 0;
        this.buttonAccept.m_93666_((Component)(myState <= 1 ? LCText.BUTTON_PLAYER_TRADING_ACCEPT.get(new Object[0]) : LCText.BUTTON_PLAYER_TRADING_CANCEL.get(new Object[0])));
        if (this.chatMode) {
            this.m_7522_((GuiEventListener)this.chatBox);
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        if (this.chatMode && !this.chatBox.m_94155_().isBlank() && keyCode == 257) {
            ((PlayerTradeMenu)this.f_97732_).SendChatToServer(this.chatBox.m_94155_());
            this.chatBox.m_94144_("");
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifier);
    }

    private void onValueChanged(MoneyValue newValue) {
        CompoundTag message = new CompoundTag();
        MoneyView availableFunds = ((PlayerTradeMenu)this.f_97732_).getAvailableFunds();
        if (!availableFunds.containsValue(newValue)) {
            newValue = availableFunds.valueOf(newValue.getUniqueName());
            this.valueInput.changeValue(newValue);
        }
        message.m_128365_("ChangeMoney", (Tag)newValue.save());
        new CPacketPlayerTradeInteraction(((PlayerTradeMenu)this.f_97732_).tradeID, message).send();
    }

    private void OnPropose(EasyButton button) {
        CompoundTag message = new CompoundTag();
        message.m_128379_("TogglePropose", true);
        new CPacketPlayerTradeInteraction(((PlayerTradeMenu)this.f_97732_).tradeID, message).send();
    }

    private void OnAccept(EasyButton button) {
        CompoundTag message = new CompoundTag();
        message.m_128379_("ToggleActive", true);
        new CPacketPlayerTradeInteraction(((PlayerTradeMenu)this.f_97732_).tradeID, message).send();
    }

    private void ToggleMoneyMode(EasyButton button) {
        this.moneyMode = !this.moneyMode;
        this.valueInput.setVisible(!this.valueInput.f_93624_);
        this.validateWidgetStates();
    }

    private void ToggleChatMode(EasyButton button) {
        boolean bl = this.chatMode = !this.chatMode;
        if (this.chatMode) {
            this.chatWarning = false;
        }
        this.validateWidgetStates();
    }

    private IconData getToggleIcon() {
        return this.chatWarning ? ItemIcon.ofItem((ItemLike)Items.f_42614_) : ItemIcon.ofItem((ItemLike)Items.f_42517_);
    }

    private Component getToggleTooltip() {
        return this.chatMode ? LCText.TOOLTIP_PLAYER_TRADING_CHAT_CLOSE.get(new Object[0]) : LCText.TOOLTIP_PLAYER_TRADING_CHAT_OPEN.get(new Object[0]);
    }

    private IconData getToggleMoneyIcon() {
        return this.moneyMode ? ItemIcon.ofItem((ItemLike)Items.f_42009_) : ItemIcon.ofItem(ModBlocks.COINPILE_GOLD);
    }

    private Component getToggleMoneyTooltip() {
        return this.moneyMode ? LCText.TOOLTIP_PLAYER_TRADING_MONEY_CLOSE.get(new Object[0]) : LCText.TOOLTIP_PLAYER_TRADING_MONEY_OPEN.get(new Object[0]);
    }

    private void validateWidgetStates() {
        this.chatScrollListener.f_93623_ = this.chatMode;
        this.chatBox.m_94194_(this.chatScrollListener.f_93623_);
        this.buttonPropose.f_93624_ = !this.chatMode && !this.moneyMode;
        this.buttonAccept.f_93624_ = this.buttonPropose.f_93624_;
        boolean bl = this.valueInput.f_93624_ = this.moneyMode && !this.chatMode;
        if (this.chatMode || this.moneyMode) {
            ((PlayerTradeMenu)this.f_97732_).hideSlots();
        } else {
            ((PlayerTradeMenu)this.f_97732_).showSlots();
        }
    }

    private void receiveChat(@Nonnull Component chat) {
        List newLines = this.f_96547_.m_92923_((FormattedText)chat, this.getXSize() - 14);
        for (FormattedCharSequence line : newLines) {
            this.chatHistory.add(0, line);
        }
        if (!this.chatMode) {
            this.chatWarning = true;
        }
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(11, this.chatHistory.size());
    }
}

