/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_management;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_management.EditableChainData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_management.tabs.CoinManagementTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_management.tabs.SelectChainTab;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.CoinManagementMenu;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.ItemLike;

public class CoinManagementScreen
extends EasyMenuScreen<CoinManagementMenu> {
    private final Map<String, EditableChainData> editableDataMap = new HashMap<String, EditableChainData>();
    private int selectedTab = 0;
    private final List<CoinManagementTab> allTabs = ImmutableList.of((Object)new SelectChainTab(this));
    private String selectedChain = "main";

    public Collection<EditableChainData> getEditableChains() {
        return this.editableDataMap.values();
    }

    private CoinManagementTab currentTab() {
        return this.allTabs.get(this.selectedTab);
    }

    public EditableChainData getSelectedChain() {
        return this.editableDataMap.get(this.selectedChain);
    }

    public CoinManagementScreen(CoinManagementMenu menu, Inventory inventory, Component ignored) {
        super(menu, inventory);
        for (ChainData data : CoinAPI.getApi().AllChainData()) {
            this.editableDataMap.put(data.chain, new EditableChainData(data));
        }
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        screenArea = this.resize(screenArea.width, screenArea.height);
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        this.currentTab().renderBG(gui);
    }

    @Override
    protected void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        this.currentTab().renderAfterWidgets(gui);
    }

    public void CreateChain(@Nonnull String chain, @Nonnull ItemLike coreCoin, @Nonnull String chainName) {
        if (this.editableDataMap.containsKey(chain)) {
            return;
        }
        EditableChainData newChain = new EditableChainData(chain, coreCoin, chainName);
        this.editableDataMap.put(chain, newChain);
        this.selectedChain = chain;
    }

    public void DeleteChain(@Nonnull String chain) {
        if (chain.equals("main")) {
            LightmansCurrency.LogWarning("Cannot delete the `main` chain no matter what!");
            return;
        }
        this.editableDataMap.remove(chain);
        if (this.selectedChain.equals(chain)) {
            this.selectedChain = "main";
        }
    }

    public void ChangeChainID(@Nonnull String oldID, @Nonnull String newID, boolean allowOverride) {
        if (this.editableDataMap.containsKey(newID) && !allowOverride) {
            LightmansCurrency.LogWarning("Attempted to change a chains id to another chain that already exists!");
            return;
        }
        if (oldID.equals("main")) {
            LightmansCurrency.LogInfo("Cannot delete the `main` chain even by changing its id. It will be copied instead!");
            EditableChainData copy = this.editableDataMap.get(oldID).copy();
            this.editableDataMap.put(newID, copy);
        } else {
            EditableChainData data = this.editableDataMap.get(oldID);
            data.chainID = newID;
            this.editableDataMap.remove(oldID);
            this.editableDataMap.put(newID, data);
            if (this.selectedChain.equals(oldID)) {
                this.selectedChain = newID;
            }
        }
    }

    public void SaveChanges() {
        if (EditableChainData.isSaveable(this.getEditableChains())) {
            JsonObject root = new JsonObject();
            JsonArray chainList = new JsonArray();
            root.add("Chains", (JsonElement)chainList);
            Gson g = new GsonBuilder().create();
            String json = g.toJson((JsonElement)root);
            ((CoinManagementMenu)this.f_97732_).SendMessageToServer(LazyPacketData.simpleString("SaveData", json));
        }
    }
}

