/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.tax_collector;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TaxCollectorScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.TaxCollectorMenu;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.TaxCollectorClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.tabs.BasicSettingsTab;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BasicSettingsClientTab
extends TaxCollectorClientTab<BasicSettingsTab> {
    private EditBox nameInput;
    private boolean showAreaButtons = true;

    public BasicSettingsClientTab(Object screen, BasicSettingsTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_TAXES;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_TAX_COLLECTOR_BASIC.get(new Object[0]);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        TaxEntry entry = this.getEntry();
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(8, 16))).pressAction(this::ToggleActiveState)).sprite(SpriteUtil.createCheckbox(this::isEntryActive)).addon(EasyAddonHelper.visibleCheck(this::canActiveToggle))).build());
        this.addChild(((DropdownWidget.Builder)((DropdownWidget.Builder)DropdownWidget.builder().position(screenArea.pos.offset(screenArea.width - 88, 26))).width(80).selected(entry == null ? 0 : entry.getRenderMode()).selectAction(((BasicSettingsTab)this.commonTab)::SetRenderMode).option(LCText.GUI_TAX_COLLECTOR_RENDER_MODE_NONE).option(LCText.GUI_TAX_COLLECTOR_RENDER_MODE_MEMBERS).option(LCText.GUI_TAX_COLLECTOR_RENDER_MODE_ALL).addon(EasyAddonHelper.visibleCheck(this::showAreaButtons))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(6, 32))).pressAction(() -> ((BasicSettingsTab)this.commonTab).SetRate(this.getCurrentRate() + (Screen.m_96638_() ? 10 : 1)))).sprite(SpriteUtil.BUTTON_SIGN_PLUS).addon(EasyAddonHelper.activeCheck(() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getTaxRate() < TaxEntry.maxTaxRate();
        }))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(6, 42))).pressAction(() -> ((BasicSettingsTab)this.commonTab).SetRate(this.getCurrentRate() - (Screen.m_96638_() ? 10 : 1)))).sprite(SpriteUtil.BUTTON_SIGN_MINUS).addon(EasyAddonHelper.activeCheck(() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getTaxRate() > 1;
        }))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(22, screenArea.height - 16))).pressAction(() -> ((BasicSettingsTab)this.commonTab).SetRadius(this.getCurrentRadius() + (Screen.m_96638_() ? 10 : 1)))).sprite(SpriteUtil.BUTTON_SIGN_PLUS).addon(EasyAddonHelper.visibleCheck(this::showAreaButtons))).addon(EasyAddonHelper.activeCheck(() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getRadius() < TaxEntry.maxRadius();
        }))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(32, screenArea.height - 16))).pressAction(() -> ((BasicSettingsTab)this.commonTab).SetRadius(this.getCurrentRadius() - (Screen.m_96638_() ? 10 : 1)))).sprite(SpriteUtil.BUTTON_SIGN_MINUS).addon(EasyAddonHelper.visibleCheck(this::showAreaButtons))).addon(EasyAddonHelper.activeCheck(() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getRadius() > TaxEntry.minRadius();
        }))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(screenArea.width / 2 - 10, screenArea.height - 16))).pressAction(() -> ((BasicSettingsTab)this.commonTab).SetHeight(this.getCurrentHeight() + (Screen.m_96638_() ? 10 : 1)))).sprite(SpriteUtil.BUTTON_SIGN_PLUS).addon(EasyAddonHelper.visibleCheck(this::showAreaButtons))).addon(EasyAddonHelper.activeCheck(() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getHeight() < TaxEntry.maxHeight();
        }))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(screenArea.width / 2, screenArea.height - 16))).pressAction(() -> ((BasicSettingsTab)this.commonTab).SetHeight(this.getCurrentHeight() - (Screen.m_96638_() ? 10 : 1)))).sprite(SpriteUtil.BUTTON_SIGN_MINUS).addon(EasyAddonHelper.visibleCheck(this::showAreaButtons))).addon(EasyAddonHelper.activeCheck(() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getHeight() > TaxEntry.minHeight();
        }))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(screenArea.width - 42, screenArea.height - 16))).pressAction(() -> ((BasicSettingsTab)this.commonTab).SetVertOffset(this.getCurrentVertOffset() + (Screen.m_96638_() ? 10 : 1)))).sprite(SpriteUtil.BUTTON_SIGN_PLUS).addon(EasyAddonHelper.visibleCheck(this::showAreaButtons))).addon(EasyAddonHelper.activeCheck(() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getVertOffset() < TaxEntry.maxVertOffset();
        }))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(screenArea.width - 32, screenArea.height - 16))).pressAction(() -> ((BasicSettingsTab)this.commonTab).SetVertOffset(this.getCurrentVertOffset() - (Screen.m_96638_() ? 10 : 1)))).sprite(SpriteUtil.BUTTON_SIGN_MINUS).addon(EasyAddonHelper.visibleCheck(this::showAreaButtons))).addon(EasyAddonHelper.activeCheck(() -> {
            TaxEntry e = this.getEntry();
            return e != null && e.getVertOffset() > TaxEntry.minVertOffset();
        }))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(8, 58))).pressAction(() -> ((BasicSettingsTab)this.commonTab).SetBankAccountLink(!this.getCurrentBankAccountLink()))).sprite(SpriteUtil.createCheckbox(this::getCurrentBankAccountLink)).addon(EasyAddonHelper.visibleCheck(() -> !((TaxCollectorMenu)this.menu).isServerEntry()))).build());
        this.nameInput = this.addChild(new EditBox(this.getFont(), screenArea.pos.x + 10, screenArea.pos.y + 80, screenArea.width - 20, 18, (Component)EasyText.empty()));
        this.nameInput.m_94144_(entry != null ? entry.getCustomName() : "");
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(10, 102))).width(70)).text(LCText.BUTTON_SETTINGS_CHANGE_NAME).pressAction(() -> ((BasicSettingsTab)this.commonTab).SetName(this.getCurrentNameInput()))).addon(EasyAddonHelper.activeCheck(this::isNameDifferent))).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(96, 102))).width(70)).text(LCText.BUTTON_SETTINGS_RESET_NAME).pressAction(this::ResetName)).addon(EasyAddonHelper.activeCheck(this::hasCustomName))).build());
        this.tick();
    }

    @Override
    public void tick() {
        TaxEntry entry = this.getEntry();
        this.showAreaButtons = entry != null && !entry.isInfiniteRange();
    }

    private boolean isEntryActive() {
        TaxEntry entry = this.getEntry();
        return entry != null && entry.isActive();
    }

    private boolean canActiveToggle() {
        TaxEntry entry = this.getEntry();
        return entry != null && ((Boolean)LCConfig.SERVER.taxCollectorAdminOnly.get() == false || ((TaxCollectorMenu)this.menu).isAdmin() || entry.isActive());
    }

    private boolean showAreaButtons() {
        return this.showAreaButtons;
    }

    private int getCurrentRate() {
        TaxEntry entry = this.getEntry();
        return entry != null ? entry.getTaxRate() : 0;
    }

    private int getCurrentRadius() {
        TaxEntry entry = this.getEntry();
        return entry != null ? entry.getRadius() : 0;
    }

    private int getCurrentHeight() {
        TaxEntry entry = this.getEntry();
        return entry != null ? entry.getHeight() : 0;
    }

    private int getCurrentVertOffset() {
        TaxEntry entry = this.getEntry();
        return entry != null ? entry.getVertOffset() : 0;
    }

    private boolean getCurrentBankAccountLink() {
        TaxEntry entry = this.getEntry();
        return entry != null && entry.isLinkedToBank();
    }

    private String getCurrentNameInput() {
        if (this.nameInput == null) {
            return "";
        }
        return this.nameInput.m_94155_();
    }

    private boolean isNameDifferent() {
        TaxEntry entry = this.getEntry();
        if (entry != null) {
            return !entry.getCustomName().equals(this.getCurrentNameInput());
        }
        return false;
    }

    private boolean hasCustomName() {
        TaxEntry entry = this.getEntry();
        if (entry != null) {
            return !entry.getCustomName().isBlank();
        }
        return false;
    }

    private void ResetName() {
        ((BasicSettingsTab)this.commonTab).SetName("");
        this.nameInput.m_94144_("");
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
        TaxEntry entry = this.getEntry();
        if (entry == null) {
            return;
        }
        gui.drawString((Component)entry.getName(), 8, 6, 0x404040);
        gui.drawString((Component)LCText.GUI_TAX_COLLECTOR_ACTIVE.get(new Object[0]), 20, 18, entry != null && entry.isActive() ? 65280 : 0xFF0000);
        if (this.showAreaButtons) {
            MutableComponent label = LCText.GUI_TAX_COLLECTOR_RENDER_MODE_LABEL.get(new Object[0]);
            gui.drawString((Component)label, ((TaxCollectorScreen)this.screen).getXSize() - 8 - gui.font.m_92852_((FormattedText)label), 16, 0x404040);
        }
        gui.drawString((Component)LCText.GUI_TAX_COLLECTOR_TAX_RATE.get(entry.getTaxRate()), 18, 39, 0x404040);
        if (!entry.isServerEntry()) {
            gui.drawString((Component)LCText.GUI_SETTINGS_BANK_LINK.get(new Object[0]), 20, 60, 0x404040);
        }
        if (entry.isInfiniteRange()) {
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TAX_COLLECTOR_AREA_INFINITE_LABEL.get(new Object[0]), ((TaxCollectorScreen)this.screen).getXSize() / 2, ((TaxCollectorScreen)this.screen).getYSize() - 38, 0x404040);
            MutableComponent areaText = entry.getCenter().isVoid() ? LCText.GUI_TAX_COLLECTOR_AREA_INFINITE_VOID.get(new Object[0]) : LCText.GUI_TAX_COLLECTOR_AREA_INFINITE_DIMENSION.get(entry.getCenter().getDimension().m_135782_());
            TextRenderUtil.drawCenteredText(gui, (Component)areaText, ((TaxCollectorScreen)this.screen).getXSize() / 2, ((TaxCollectorScreen)this.screen).getYSize() - 28, 0x404040);
        } else {
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TAX_COLLECTOR_AREA_RADIUS.get(new Object[0]), 32, ((TaxCollectorScreen)this.screen).getYSize() - 38, 0x404040);
            TextRenderUtil.drawCenteredText(gui, Integer.toString(entry.getRadius()), 32, ((TaxCollectorScreen)this.screen).getYSize() - 28, 0x404040);
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TAX_COLLECTOR_AREA_HEIGHT.get(new Object[0]), ((TaxCollectorScreen)this.screen).getXSize() / 2, ((TaxCollectorScreen)this.screen).getYSize() - 38, 0x404040);
            TextRenderUtil.drawCenteredText(gui, Integer.toString(entry.getHeight()), ((TaxCollectorScreen)this.screen).getXSize() / 2, ((TaxCollectorScreen)this.screen).getYSize() - 28, 0x404040);
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TAX_COLLECTOR_AREA_VERTOFFSET.get(new Object[0]), ((TaxCollectorScreen)this.screen).getXSize() - 32, ((TaxCollectorScreen)this.screen).getYSize() - 38, 0x404040);
            TextRenderUtil.drawCenteredText(gui, Integer.toString(entry.getVertOffset()), ((TaxCollectorScreen)this.screen).getXSize() - 32, ((TaxCollectorScreen)this.screen).getYSize() - 28, 0x404040);
        }
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.nameInput.m_93696_();
    }

    private void ToggleActiveState(EasyButton button) {
        ((BasicSettingsTab)this.commonTab).SetActive(!this.isEntryActive());
    }
}

