/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.data.TradeReference;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.base.InfoTab;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class InfoClientTab
extends TraderInterfaceClientTab<InfoTab>
implements IScrollable {
    TradeButton tradeDisplay;
    TradeButton newTradeDisplay;
    DropdownWidget interactionDropdown;
    EasyButton acceptChangesButton;
    private final ScreenArea WARNING_AREA = ScreenArea.of(45, 69, 16, 16);
    private int scroll = 0;

    public InfoClientTab(Object screen, InfoTab tab) {
        super(screen, tab);
    }

    @Override
    public IconData getIcon() {
        return ItemIcon.ofItem((ItemLike)Items.f_42516_);
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_INTERFACE_INFO.get(new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.tradeDisplay = this.addChild(((TradeButton.Builder)((TradeButton.Builder)TradeButton.builder().position(screenArea.pos.offset(6, 47))).context(this::getTradeContext).trade(this::getReferencedTrade).displayOnly().addon(EasyAddonHelper.visibleCheck(() -> ((TraderInterfaceMenu)this.menu).getBE().getInteractionType().trades()))).build());
        this.newTradeDisplay = this.addChild(((TradeButton.Builder)((TradeButton.Builder)TradeButton.builder().position(screenArea.pos.offset(6, 91))).context(this::getTradeContext).trade(this::getTrueTrade).displayOnly().addon(EasyAddonHelper.visibleCheck(() -> ((TraderInterfaceMenu)this.menu).getBE().getInteractionType().trades() && this.changeInTrades()))).build());
        this.newTradeDisplay.f_93624_ = false;
        this.interactionDropdown = this.addChild(InfoClientTab.interactionTypeDropdown(screenArea.pos.offset(104, 25), 97, ((TraderInterfaceMenu)((TraderInterfaceScreen)this.screen).m_6262_()).getBE().getInteractionType(), this::onInteractionSelect, ((TraderInterfaceMenu)this.menu).getBE().getBlacklistedInteractions()));
        this.acceptChangesButton = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(181, 90))).pressAction(this::AcceptTradeChanges)).icon(IconUtil.ICON_CHECKMARK).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_INTERFACE_INFO_ACCEPT_CHANGES))).addon(EasyAddonHelper.visibleCheck(() -> ((TraderInterfaceMenu)this.menu).getBE().getInteractionType().trades() && this.changeInTrades()))).build());
        this.acceptChangesButton.f_93624_ = false;
        this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(-20, 98))).pressAction(() -> this.changeScroll(-1))).icon(IconUtil.ICON_LEFT).addon(EasyAddonHelper.activeCheck(() -> this.scroll > 0))).addon(EasyAddonHelper.visibleCheck(this::isScrollRelevant))).build());
        this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width, 98))).pressAction(() -> this.changeScroll(1))).icon(IconUtil.ICON_RIGHT).addon(EasyAddonHelper.activeCheck(() -> this.scroll < this.getMaxScroll() && this.getMaxScroll() > 0))).addon(EasyAddonHelper.visibleCheck(this::isScrollRelevant))).build());
    }

    private static DropdownWidget interactionTypeDropdown(ScreenPosition position, int width, TraderInterfaceBlockEntity.InteractionType currentlySelected, Consumer<Integer> onSelect, List<TraderInterfaceBlockEntity.InteractionType> blacklist) {
        DropdownWidget.Builder builder = ((DropdownWidget.Builder)DropdownWidget.builder().position(position)).width(width).selected(currentlySelected.index).selectAction(onSelect).activeCheck(i -> !blacklist.contains((Object)TraderInterfaceBlockEntity.InteractionType.fromIndex(i)));
        for (int i2 = 0; i2 < TraderInterfaceBlockEntity.InteractionType.size(); ++i2) {
            builder.option(TraderInterfaceBlockEntity.InteractionType.fromIndex(i2).getDisplayText());
        }
        return builder.build();
    }

    private List<Component> getWarningMessages() {
        if (((TraderInterfaceMenu)this.menu).getBE() == null) {
            return new ArrayList<Component>();
        }
        TradeReference tradeReference = this.getTradeReference();
        if (tradeReference == null) {
            return new ArrayList<Component>();
        }
        ArrayList<Component> list = new ArrayList<Component>();
        TradeResult result = tradeReference.getLastResult();
        MutableComponent message = result.getMessage();
        if (message != null) {
            list.add((Component)message);
        }
        if (((TraderInterfaceMenu)this.menu).getBE().getInteractionType().trades()) {
            TradeData referencedTrade = tradeReference.getLocalTrade();
            TradeData trueTrade = tradeReference.getTrueTrade();
            if (trueTrade == null) {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_MISSING.getWithStyle(ChatFormatting.RED));
                return list;
            }
            TradeComparisonResult differences = trueTrade.compare(referencedTrade);
            if (!differences.TypeMatches()) {
                list.add((Component)LCText.GUI_TRADE_DIFFERENCE_TYPE.getWithStyle(ChatFormatting.RED));
                return list;
            }
            list.addAll(trueTrade.GetDifferenceWarnings(differences));
            return list;
        }
        return list;
    }

    private TradeContext getTradeContext() {
        TraderInterfaceBlockEntity be = ((TraderInterfaceMenu)this.menu).getBE();
        TraderData trader = be.targets.getTrader();
        if (trader == null) {
            return null;
        }
        return be.getTradeContext(trader);
    }

    @Nullable
    private TradeReference getTradeReference() {
        TraderInterfaceBlockEntity be = ((TraderInterfaceMenu)this.menu).getBE();
        if (be.getInteractionType().trades()) {
            List<TradeReference> trades = be.targets.getTradeReferences();
            this.validateScroll();
            if (this.scroll < 0 || this.scroll >= trades.size()) {
                return null;
            }
            return trades.get(this.scroll);
        }
        return null;
    }

    @Nullable
    private TradeData getReferencedTrade() {
        TradeReference tradeReference = this.getTradeReference();
        return tradeReference == null ? null : tradeReference.getLocalTrade();
    }

    @Nullable
    private TradeData getTrueTrade() {
        TradeReference tradeReference = this.getTradeReference();
        return tradeReference == null ? null : tradeReference.getTrueTrade();
    }

    public boolean isScrollRelevant() {
        return ((TraderInterfaceMenu)this.menu).getBE().getInteractionType().trades() && ((TraderInterfaceMenu)this.menu).getBE().getSelectableCount() > 1;
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
        if (((TraderInterfaceMenu)this.menu).getBE() == null) {
            return;
        }
        gui.drawString((Component)((TraderInterfaceMenu)this.menu).getBE().m_58900_().m_60734_().m_49954_(), 8, 6, 0x404040);
        TraderInterfaceBlockEntity be = ((TraderInterfaceMenu)this.menu).getBE();
        if (be.getInteractionType().targetsTraders()) {
            List<TraderData> traders = be.targets.getTraders();
            MutableComponent traderNames = EasyText.empty();
            if (traders.isEmpty()) {
                traderNames = LCText.GUI_INTERFACE_INFO_TRADER_NULL.get(new Object[0]);
            } else {
                for (TraderData trader : traders) {
                    if (traderNames.getString().isEmpty()) {
                        traderNames.m_7220_((Component)trader.getTitle());
                        continue;
                    }
                    traderNames.m_7220_((Component)LCText.GUI_SEPERATOR.get(new Object[0])).m_7220_((Component)trader.getTitle());
                }
            }
            List lines = gui.font.m_92923_((FormattedText)traderNames, ((TraderInterfaceScreen)this.screen).getXSize() - 40);
            for (int y = 0; y < lines.size() && y < 8; ++y) {
                gui.drawString((FormattedCharSequence)lines.get(y), 8, 38 + 10 * y, 0x404040);
            }
        } else {
            TraderData trader = be.targets.getTrader();
            MutableComponent traderName = trader != null ? trader.getTitle() : LCText.GUI_INTERFACE_INFO_TRADER_NULL.get(new Object[0]);
            gui.drawString(TextRenderUtil.fitString((Component)traderName, ((TraderInterfaceScreen)this.screen).getXSize() - 16), 8, 16, 0x404040);
            IBankAccount account = ((TraderInterfaceMenu)this.menu).getBE().getBankAccount();
            if (account != null) {
                Component accountName = TextRenderUtil.fitString((Component)account.getName(), 160);
                gui.drawString(accountName, 103 - gui.font.m_92852_((FormattedText)accountName) / 2, 120, 0x404040);
                MutableComponent balanceText = account.getBalanceText();
                gui.drawString((Component)balanceText, 103 - gui.font.m_92852_((FormattedText)balanceText) / 2, 130, 0x404040);
            }
            if (trader == null) {
                return;
            }
            if (this.changeInTrades()) {
                gui.resetColor();
                gui.blit(TraderInterfaceScreen.GUI_TEXTURE, this.tradeDisplay.m_5711_() / 2 - 2, 67, 206, 0, 16, 22);
                if (this.getTrueTrade() == null) {
                    MutableComponent mutableComponent = LCText.GUI_INTERFACE_INFO_TRADE_MISSING.getWithStyle(ChatFormatting.RED);
                    Objects.requireNonNull(gui.font);
                    gui.drawString((Component)mutableComponent, 6, 109 - 9, 0x404040);
                }
            }
            if (!this.getWarningMessages().isEmpty()) {
                gui.resetColor();
                SpriteUtil.GENERIC_ALERT.render(gui, this.WARNING_AREA.x, this.WARNING_AREA.y);
            }
        }
    }

    public boolean changeInTrades() {
        TradeReference tradeReference = this.getTradeReference();
        if (tradeReference == null) {
            return false;
        }
        TradeData referencedTrade = tradeReference.getLocalTrade();
        TradeData trueTrade = tradeReference.getTrueTrade();
        if (referencedTrade == null) {
            return false;
        }
        if (trueTrade == null) {
            return true;
        }
        return !referencedTrade.compare(trueTrade).Identical();
    }

    @Override
    public void renderAfterWidgets(EasyGuiGraphics gui) {
        List<Component> warnings;
        if (((TraderInterfaceMenu)this.menu).getBE() == null) {
            return;
        }
        if (this.WARNING_AREA.atPosition(this.WARNING_AREA.pos.offset(this.screen)).isMouseInArea(gui.mousePos) && !(warnings = this.getWarningMessages()).isEmpty()) {
            gui.renderComponentTooltip(warnings);
        }
    }

    private void onInteractionSelect(int newTypeIndex) {
        TraderInterfaceBlockEntity.InteractionType newType = TraderInterfaceBlockEntity.InteractionType.fromIndex(newTypeIndex);
        ((InfoTab)this.commonTab).changeInteractionType(newType);
    }

    private void AcceptTradeChanges() {
        ((InfoTab)this.commonTab).acceptTradeChanges(this.scroll);
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    private void changeScroll(int delta) {
        this.setScroll(this.scroll + delta);
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, ((TraderInterfaceMenu)this.menu).getBE().targets.getTradeReferences().size() - 1);
    }
}

