/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.easy;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class EasyWidget
extends AbstractWidget {
    private ScreenArea area;
    private final List<WidgetAddon> addons = new ArrayList<WidgetAddon>();
    private boolean lockAddons = false;

    public final ScreenArea getArea() {
        return this.area;
    }

    public final int m_252754_() {
        return this.area.x;
    }

    public final void m_252865_(int x) {
        this.area = this.area.atPosition(ScreenPosition.of(x, this.area.y));
    }

    public final int m_252907_() {
        return this.area.y;
    }

    public final void m_253211_(int y) {
        this.area = this.area.atPosition(ScreenPosition.of(this.area.x, y));
    }

    public final ScreenPosition getPosition() {
        return this.area.pos;
    }

    public final void m_264152_(int x, int y) {
        this.area = this.area.atPosition(x, y);
    }

    public final void setPosition(ScreenPosition pos) {
        this.area = this.area.atPosition(pos);
    }

    public final int m_5711_() {
        return this.area.width;
    }

    public final int m_93694_() {
        return this.area.height;
    }

    public final void m_93674_(int width) {
        this.area = this.area.ofSize(width, this.area.height);
        super.m_93674_(width);
    }

    public final void setHeight(int height) {
        this.area = this.area.ofSize(this.area.width, height);
        super.setHeight(height);
    }

    public final void setSize(int width, int height) {
        this.area = this.area.ofSize(width, height);
        super.m_93674_(width);
        super.setHeight(height);
    }

    public final boolean isVisible() {
        this.visibleTickInternal();
        return this.f_93624_;
    }

    public final void setVisible(boolean visible) {
        this.f_93624_ = visible;
    }

    public final Font getFont() {
        return Minecraft.m_91087_().f_91062_;
    }

    public boolean hideFromMouse() {
        return false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (this.hideFromMouse()) {
            return false;
        }
        this.activeTickInternal();
        return super.m_5953_(mouseX, mouseY);
    }

    public final boolean m_142518_() {
        this.activeTickInternal();
        return super.m_142518_();
    }

    public final void setActive(boolean active) {
        this.f_93623_ = active;
    }

    public final boolean isMouseOver(ScreenPosition mousePos) {
        return this.m_5953_(mousePos.x, mousePos.y);
    }

    protected EasyWidget(EasyBuilder<?> builder) {
        super(builder.area.x, builder.area.y, builder.area.width, builder.area.height, (Component)EasyText.empty());
        this.area = builder.area;
        this.withAddonsInternal(builder.addons);
    }

    protected final void withAddonsInternal(List<WidgetAddon> addons) {
        if (this.lockAddons) {
            return;
        }
        for (WidgetAddon a : addons) {
            if (a == null || this.addons.contains(a)) continue;
            this.addons.add(a);
            a.attach(this);
        }
    }

    public final void addAddons(Consumer<WidgetAddon> consumer) {
        this.lockAddons = true;
        for (WidgetAddon addon : this.addons) {
            consumer.accept(addon);
        }
    }

    public void removeAddons(Consumer<WidgetAddon> consumer) {
        for (WidgetAddon addon : this.addons) {
            consumer.accept(addon);
        }
    }

    private void visibleTickInternal() {
        this.addons.forEach(WidgetAddon::visibleTick);
    }

    private void activeTickInternal() {
        this.visibleTickInternal();
        this.addons.forEach(WidgetAddon::activeTick);
    }

    public final void renderTickInternal() {
        this.activeTickInternal();
        this.addons.forEach(WidgetAddon::renderTick);
        this.renderTick();
    }

    protected void renderTick() {
    }

    public final void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.renderTickInternal();
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
    }

    protected final void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        try {
            this.renderWidget(EasyGuiGraphics.create(gui, mouseX, mouseY, partialTicks).pushOffset(this.getPosition()));
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error occurred while rendering " + ((Object)((Object)this)).getClass().getName(), t);
        }
    }

    protected abstract void renderWidget(EasyGuiGraphics var1);

    protected boolean m_7972_(int button) {
        return false;
    }

    public void m_7435_(SoundManager manager) {
    }

    protected void m_168797_(NarrationElementOutput narrator) {
    }

    public static void drawScrollingString(GuiGraphics gui, Font font, Component text, int startX, int startY, int stopX, int stopY, int color) {
        AbstractWidget.m_280138_((GuiGraphics)gui, (Font)font, (Component)text, (int)startX, (int)startY, (int)stopX, (int)stopY, (int)color);
    }

    @FieldsAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public static abstract class EasyBuilder<T extends EasyBuilder<T>> {
        private ScreenArea area;
        private final List<WidgetAddon> addons = new ArrayList<WidgetAddon>();

        protected EasyBuilder() {
            this(20, 20);
        }

        protected EasyBuilder(int defaultWidth, int defaultHeight) {
            this.area = ScreenArea.of(0, 0, defaultWidth, defaultHeight);
        }

        protected abstract T getSelf();

        public final T position(int x, int y) {
            this.area = this.area.atPosition(x, y);
            return this.getSelf();
        }

        public final T position(ScreenPosition position) {
            this.area = this.area.atPosition(position);
            return this.getSelf();
        }

        protected final void changeWidth(int width) {
            this.area = this.area.ofSize(width, this.area.height);
        }

        protected final void changeHeight(int height) {
            this.area = this.area.ofSize(this.area.width, height);
        }

        protected final void changeSize(int width, int height) {
            this.area = this.area.ofSize(width, height);
        }

        public final T addon(WidgetAddon addon) {
            this.addons.add(addon);
            return this.getSelf();
        }

        public final T copyFrom(EasyBuilder<?> other) {
            this.area = other.area;
            this.addons.clear();
            this.addons.addAll(other.addons);
            return this.getSelf();
        }
    }

    public static abstract class EasySizableBuilder<T extends EasySizableBuilder<T>>
    extends EasyBuilder<T> {
        protected EasySizableBuilder() {
        }

        protected EasySizableBuilder(int defaultWidth, int defaultHeight) {
            super(defaultWidth, defaultHeight);
        }

        public final T area(ScreenArea area) {
            this.changeSize(area.width, area.height);
            this.position(area.pos);
            return (T)((EasySizableBuilder)this.getSelf());
        }

        public final T width(int width) {
            this.changeWidth(width);
            return (T)((EasySizableBuilder)this.getSelf());
        }

        public final T height(int height) {
            this.changeHeight(height);
            return (T)((EasySizableBuilder)this.getSelf());
        }

        public final T size(int width, int height) {
            this.changeSize(width, height);
            return (T)((EasySizableBuilder)this.getSelf());
        }
    }
}

