/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelLocation;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperties;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin.FreezerDoorData;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.FreezerTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.FreezerBlock;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class FreezerTraderBlockEntityRenderer
implements BlockEntityRenderer<FreezerTraderBlockEntity> {
    private FreezerTraderBlockEntityRenderer() {
    }

    public static FreezerTraderBlockEntityRenderer create(BlockEntityRendererProvider.Context ignored) {
        return new FreezerTraderBlockEntityRenderer();
    }

    public void render(@Nonnull FreezerTraderBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int lightLevel, int id) {
        ItemTraderBlockEntityRenderer.renderItems(blockEntity, partialTicks, poseStack, bufferSource, lightLevel, id);
        Block block = blockEntity.m_58900_().m_60734_();
        if (block instanceof FreezerBlock) {
            FreezerBlock freezerBlock = (FreezerBlock)block;
            poseStack.m_85836_();
            Direction facing = freezerBlock.getFacing(blockEntity.m_58900_());
            Vector3f corner = IRotatableBlock.getOffsetVect(facing);
            Vector3f right = IRotatableBlock.getRightVect(facing);
            Vector3f forward = IRotatableBlock.getForwardVect(facing);
            FreezerDoorData doorData = FreezerDoorData.DEFAULT;
            ModelVariant variant = ModelVariantDataManager.getVariant(blockEntity.getCurrentVariant());
            if (variant != null && variant.getTargets().contains(freezerBlock.getBlockID())) {
                doorData = variant.getOrDefault(VariantProperties.FREEZER_DOOR_DATA, FreezerDoorData.DEFAULT);
            }
            Vector3f hinge = MathUtil.VectorAdd(corner, MathUtil.VectorMult(right, doorData.hingeX()), MathUtil.VectorMult(forward, doorData.hingeZ()));
            Quaternionf rotation = MathUtil.fromAxisAngleDegree(MathUtil.getYP(), (float)facing.m_122416_() * -90.0f + doorData.rotation() * blockEntity.getDoorAngle(partialTicks));
            poseStack.m_252880_(hinge.x(), hinge.y(), hinge.z());
            poseStack.m_252781_(rotation);
            Minecraft mc = Minecraft.m_91087_();
            BakedModel model = mc.m_91304_().getModel(freezerBlock.getDoorModel());
            if (variant != null && variant.isValidTarget(freezerBlock) && variant.getModels().size() == freezerBlock.requiredModels()) {
                VariantModelLocation newModel = VariantModelLocation.basic(blockEntity.getCurrentVariant(), freezerBlock.getBlockID(), freezerBlock.requiredModels() - 1);
                model = ModelVariantDataManager.getModel(newModel);
            }
            ItemRenderer itemRenderer = mc.m_91291_();
            itemRenderer.m_115143_(new ItemStack((ItemLike)freezerBlock), ItemDisplayContext.FIXED, false, poseStack, bufferSource, lightLevel, OverlayTexture.f_118083_, model);
            poseStack.m_85849_();
        }
    }
}

