/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.filter.FilterAPI;
import io.github.lightman314.lightmanscurrency.api.filter.IItemTradeFilter;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.config.CustomItemScaleData;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.CustomModelDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.ItemPositionData;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperties;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.ListUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ItemTraderBlockEntityRenderer
implements BlockEntityRenderer<ItemTraderBlockEntity> {
    private static long rotationTime = 0L;

    private ItemTraderBlockEntityRenderer() {
    }

    public static ItemTraderBlockEntityRenderer create(BlockEntityRendererProvider.Context context) {
        return new ItemTraderBlockEntityRenderer();
    }

    public void render(@Nonnull ItemTraderBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, int lightLevel, int id) {
        ItemTraderBlockEntityRenderer.renderItems(blockEntity, partialTicks, pose, buffer, lightLevel, id);
    }

    public static List<ItemStack> GetRenderItems(ItemTradeData trade, ItemTraderData trader) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < 2; ++i) {
            ItemStack internalItem = trade.getActualItem(i);
            IItemTradeFilter filter = FilterAPI.tryGetFilter(internalItem);
            if (filter != null && filter.getFilter(internalItem) != null && trade.allowFilters()) {
                List<ItemStack> displayItems;
                if (trade.isSale() || trade.isBarter()) {
                    displayItems = filter.getDisplayableItems(internalItem, trader.getStorage());
                    if (displayItems.isEmpty() && trader.isCreative()) {
                        displayItems = filter.getDisplayableItems(internalItem, null);
                    }
                } else {
                    displayItems = filter.getDisplayableItems(internalItem, null);
                }
                result.add(ListUtil.randomItemFromList(displayItems, internalItem));
                continue;
            }
            ItemStack item = trade.getSellItem(i);
            if (item.m_41619_()) continue;
            result.add(item);
        }
        return result;
    }

    public static void renderItems(ItemTraderBlockEntity blockEntity, float partialTicks, PoseStack pose, MultiBufferSource buffer, int lightLevel, int overlay) {
        try {
            TraderData rawTrader = blockEntity.getRawTraderData();
            if (!(rawTrader instanceof ItemTraderData)) {
                return;
            }
            ItemTraderData trader = (ItemTraderData)rawTrader;
            ItemPositionData positionData = blockEntity.GetRenderData();
            ModelVariant variant = ModelVariantDataManager.getVariant(blockEntity.getCurrentVariant());
            if (variant != null && variant.has(VariantProperties.ITEM_POSITION_DATA)) {
                positionData = Objects.requireNonNullElse(variant.get(VariantProperties.ITEM_POSITION_DATA).get(), positionData);
            }
            if (positionData.isEmpty()) {
                return;
            }
            int maxIndex = positionData.getEntryCount();
            int renderLimit = (Integer)LCConfig.CLIENT.itemRenderLimit.get();
            BlockState state = blockEntity.m_58900_();
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            Level level = blockEntity.m_58904_();
            BlockPos blockPos = blockEntity.m_58899_();
            int blockLight = level.m_45517_(LightLayer.BLOCK, blockPos);
            int skyLight = level.m_45517_(LightLayer.SKY, blockPos);
            for (int tradeSlot = 0; tradeSlot < trader.getTradeCount() && tradeSlot < maxIndex; ++tradeSlot) {
                ItemTradeData trade = trader.getTrade(tradeSlot);
                List<ItemStack> renderItems = ItemTraderBlockEntityRenderer.GetRenderItems(trade, trader);
                if (renderItems.isEmpty()) continue;
                List<Vector3f> positions = positionData.getPositions(state, tradeSlot);
                List<Quaternionf> rotation = positionData.getRotation(state, tradeSlot, partialTicks);
                int minLight = positionData.getMinLight(tradeSlot);
                int itemLight = lightLevel;
                if (blockLight < minLight) {
                    itemLight = LightTexture.m_109885_((int)Math.min(minLight, level.m_7469_()), (int)skyLight);
                }
                float scale = positionData.getScale(tradeSlot);
                for (int pos = 0; pos < renderLimit && pos < positions.size() && pos < trader.getTradeStock(tradeSlot); ++pos) {
                    pose.m_85836_();
                    Vector3f position = positions.get(pos);
                    pose.m_252880_(position.x(), position.y(), position.z());
                    for (Quaternionf rot : rotation) {
                        pose.m_252781_(rot);
                    }
                    pose.m_85841_(scale, scale, scale);
                    if (renderItems.size() > 1) {
                        pose.m_85836_();
                        pose.m_85837_(0.25, 0.25, 0.0);
                        pose.m_85841_(0.5f, 0.5f, 0.5f);
                        ItemTraderBlockEntityRenderer.renderItem(blockEntity, itemRenderer, renderItems.get(0), itemLight, pose, buffer, overlay);
                        pose.m_85849_();
                        pose.m_85836_();
                        pose.m_85837_(-0.25, -0.25, 0.001);
                        pose.m_85841_(0.5f, 0.5f, 0.5f);
                        ItemTraderBlockEntityRenderer.renderItem(blockEntity, itemRenderer, renderItems.get(1), itemLight, pose, buffer, overlay);
                        pose.m_85849_();
                    } else {
                        ItemTraderBlockEntityRenderer.renderItem(blockEntity, itemRenderer, renderItems.get(0), itemLight, pose, buffer, overlay);
                    }
                    pose.m_85849_();
                }
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error rendering an Item Trader!", t);
        }
    }

    private static void renderItem(ItemTraderBlockEntity be, ItemRenderer renderer, ItemStack item, int lightLevel, PoseStack pose, MultiBufferSource buffer, int id) {
        float scale = ((CustomItemScaleData)LCConfig.CLIENT.itemScaleOverrides.get()).getCustomScale(item);
        pose.m_85841_(scale, scale, scale);
        ModelResourceLocation customModel = CustomModelDataManager.getCustomModel(be, item);
        if (customModel == null) {
            renderer.m_269128_(item, ItemDisplayContext.FIXED, lightLevel, OverlayTexture.f_118083_, pose, buffer, be.m_58904_(), id);
        } else {
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(customModel);
            renderer.m_115143_(item, ItemDisplayContext.FIXED, false, pose, buffer, lightLevel, OverlayTexture.f_118083_, model);
        }
    }

    public static long getRotationTime() {
        return rotationTime;
    }

    public static Quaternionf getRotation(float partialTicks) {
        return ItemTraderBlockEntityRenderer.getRotation(partialTicks, 2.0f);
    }

    public static Quaternionf getRotation(float partialTicks, float multiplier) {
        return new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), ((float)ItemTraderBlockEntityRenderer.getRotationTime() + partialTicks) * multiplier);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++rotationTime;
        }
    }
}

