/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.rotation;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.RotationHandler;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.RotationHandlerType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;

public class SpinningRotation
extends RotationHandler {
    private static final Map<Float, SpinningRotation> cache = new HashMap<Float, SpinningRotation>();
    public static final RotationHandlerType TYPE = SpinningRotation::parse;
    private final float speed;

    protected SpinningRotation(float speed) {
        super(TYPE);
        this.speed = speed;
    }

    public static SpinningRotation createDefault() {
        return SpinningRotation.create(2.0f);
    }

    public static SpinningRotation create(float speed) {
        if (!cache.containsKey(Float.valueOf(speed))) {
            cache.put(Float.valueOf(speed), new SpinningRotation(speed));
        }
        return cache.get(Float.valueOf(speed));
    }

    @Override
    protected List<Quaternionf> rotate(BlockState state, float partialTicks) {
        return ImmutableList.of((Object)ItemTraderBlockEntityRenderer.getRotation(partialTicks, this.speed));
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.addProperty("speed", (Number)Float.valueOf(this.speed));
    }

    private static SpinningRotation parse(JsonObject json) throws JsonSyntaxException {
        return SpinningRotation.create(GsonHelper.m_13820_((JsonObject)json, (String)"speed", (float)1.0f));
    }
}

