/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelBakery;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelLocation;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ModelVariantDataManager
implements PreparableReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final ModelVariantDataManager INSTANCE = new ModelVariantDataManager();
    public static final String DIRECTORY = "lightmanscurrency/model_variants";
    private Map<ResourceLocation, ModelVariant> variants = new HashMap<ResourceLocation, ModelVariant>();
    private Map<ResourceLocation, List<ResourceLocation>> variantsByTarget = new HashMap<ResourceLocation, List<ResourceLocation>>();
    private Map<VariantModelLocation, BakedModel> variantModels = new HashMap<VariantModelLocation, BakedModel>();
    public static Map<ResourceLocation, CompletableFuture<AtlasSet.StitchResult>> atlasPreparation = null;

    private ModelVariantDataManager() {
    }

    @Nullable
    public static ModelVariant getVariant(@Nullable ResourceLocation variant) {
        return variant == null ? null : ModelVariantDataManager.INSTANCE.variants.get(variant);
    }

    @Nonnull
    public static List<ResourceLocation> getPotentialVariants(ResourceLocation target) {
        return ModelVariantDataManager.INSTANCE.variantsByTarget.getOrDefault(target, (List<ResourceLocation>)ImmutableList.of());
    }

    @Nonnull
    public static BakedModel getModel(VariantModelLocation modelID) {
        BakedModel result = ModelVariantDataManager.INSTANCE.variantModels.get(modelID);
        if (result == null) {
            LightmansCurrency.LogWarning("Unable to find variant model of type " + modelID + "#" + Integer.toHexString(modelID.hashCode()));
            LightmansCurrency.LogInfo(ModelVariantDataManager.INSTANCE.variantModels.size() + " variant models are present at this time.");
            return Minecraft.m_91087_().m_91304_().m_119409_();
        }
        return result;
    }

    public static void forEach(Consumer<ModelVariant> consumer) {
        ModelVariantDataManager.INSTANCE.variants.forEach((id, variant) -> consumer.accept((ModelVariant)variant));
    }

    public static void forEachWithID(BiConsumer<ResourceLocation, ModelVariant> biConsumer) {
        ModelVariantDataManager.INSTANCE.variants.forEach(biConsumer);
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        preparationsProfiler.m_7242_();
        CompletableFuture<VariantMaps> variantFuture = ModelVariantDataManager.loadModelVariants(resourceManager, backgroundExecutor);
        CompletableFuture<Map<ResourceLocation, BlockModel>> blockModelFuture = ModelVariantDataManager.loadBlockModels(resourceManager, backgroundExecutor);
        CompletableFuture<Map<ResourceLocation, List<ModelBakery.LoadedJson>>> blockStateFuture = ModelVariantDataManager.loadBlockStates(resourceManager, backgroundExecutor);
        CompletionStage uploadVariants = variantFuture.thenApplyAsync(this::uploadVariants, backgroundExecutor);
        CompletionStage modelBakeryFuture = variantFuture.thenCombineAsync(blockModelFuture.thenCombineAsync(blockStateFuture, Pair::of, backgroundExecutor), (variantMaps, modelsAndStates) -> new VariantModelBakery(Minecraft.m_91087_().m_91298_(), reloadProfiler, (Map)modelsAndStates.getFirst(), (Map)modelsAndStates.getSecond(), variantMaps.variantMap));
        Map<ResourceLocation, CompletableFuture<AtlasSet.StitchResult>> atlasLoading = Objects.requireNonNull(atlasPreparation, "Vanilla Atlases are not currently loading!");
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])Stream.concat(Stream.concat(atlasLoading.values().stream(), Stream.of(uploadVariants)), Stream.of(modelBakeryFuture)).toArray(CompletableFuture[]::new)).thenApplyAsync(arg_0 -> ModelVariantDataManager.lambda$reload$4(reloadProfiler, atlasLoading, (CompletableFuture)modelBakeryFuture, arg_0))).thenCompose(state -> state.readyForUpload.thenApply(v -> state))).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAcceptAsync(state -> this.apply((ReloadState)state, reloadProfiler), gameExecutor);
    }

    private static CompletableFuture<VariantMaps> loadModelVariants(ResourceManager resourceManager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap result = new HashMap();
            SimpleJsonResourceReloadListener.m_278771_((ResourceManager)resourceManager, (String)DIRECTORY, (Gson)GSON, result);
            return result;
        }, executor).thenApply(variantData -> {
            HashMap<ResourceLocation, ModelVariant> temp = new HashMap<ResourceLocation, ModelVariant>();
            HashMap<ResourceLocation, ImmutableList.Builder> builders = new HashMap<ResourceLocation, ImmutableList.Builder>();
            variantData.forEach((id, json) -> {
                try {
                    ModelVariant variant = ModelVariant.parse(GsonHelper.m_13918_((JsonElement)json, (String)"top element"));
                    temp.put((ResourceLocation)id, variant);
                }
                catch (JsonSyntaxException | IllegalArgumentException | ResourceLocationException e) {
                    LightmansCurrency.LogError("Parsing error loading model variant data " + id, e);
                }
            });
            temp.forEach((id, variant) -> variant.validate((Map<ResourceLocation, ModelVariant>)temp, (ResourceLocation)id));
            HashMap<ResourceLocation, ModelVariant> results = new HashMap<ResourceLocation, ModelVariant>();
            HashMap<ResourceLocation, List<ResourceLocation>> results2 = new HashMap<ResourceLocation, List<ResourceLocation>>();
            temp.forEach((id, variant) -> {
                if (!variant.isInvalid()) {
                    results.put((ResourceLocation)id, (ModelVariant)variant);
                    for (ResourceLocation target : variant.getTargets()) {
                        ImmutableList.Builder builder = builders.getOrDefault(target, ImmutableList.builder());
                        builder.add(id);
                        builders.put(target, builder);
                    }
                }
            });
            builders.forEach((id, builder) -> results2.put((ResourceLocation)id, (List<ResourceLocation>)builder.build()));
            return new VariantMaps(results, results2);
        });
    }

    private static CompletableFuture<Map<ResourceLocation, BlockModel>> loadBlockModels(ResourceManager resourceManager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> ModelBakery.f_244378_.m_247457_(resourceManager), executor).thenCompose(modelMap -> {
            ArrayList<CompletableFuture<Pair>> list = new ArrayList<CompletableFuture<Pair>>(modelMap.size());
            for (Map.Entry entry : modelMap.entrySet()) {
                list.add(CompletableFuture.supplyAsync(() -> {
                    try {
                        Pair pair;
                        try (BufferedReader reader = ((Resource)entry.getValue()).m_215508_();){
                            pair = Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)BlockModel.m_111461_((Reader)reader));
                        }
                        return pair;
                    }
                    catch (Exception var7) {
                        return null;
                    }
                }, executor));
            }
            return Util.m_137567_(list).thenApply(results -> results.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond)));
        });
    }

    private static CompletableFuture<Map<ResourceLocation, List<ModelBakery.LoadedJson>>> loadBlockStates(ResourceManager resourceManager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> ModelBakery.f_244202_.m_246760_(resourceManager), executor).thenCompose(resourceMap -> {
            ArrayList<CompletableFuture<Pair>> list = new ArrayList<CompletableFuture<Pair>>(resourceMap.size());
            for (Map.Entry entry : resourceMap.entrySet()) {
                list.add(CompletableFuture.supplyAsync(() -> {
                    List list1 = (List)entry.getValue();
                    ArrayList<ModelBakery.LoadedJson> list2 = new ArrayList<ModelBakery.LoadedJson>(list1.size());
                    for (Resource resource : list1) {
                        try {
                            BufferedReader reader = resource.m_215508_();
                            try {
                                JsonObject jsonobject = GsonHelper.m_13859_((Reader)reader);
                                list2.add(new ModelBakery.LoadedJson(resource.m_215506_(), (JsonElement)jsonobject));
                            }
                            finally {
                                if (reader == null) continue;
                                ((Reader)reader).close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                    return Pair.of((Object)((ResourceLocation)entry.getKey()), list2);
                }, executor));
            }
            return Util.m_137567_(list).thenApply(p_248966_ -> p_248966_.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond)));
        });
    }

    private Void uploadVariants(VariantMaps variantMaps) {
        this.variants = ImmutableMap.copyOf(variantMaps.variantMap);
        this.variantsByTarget = ImmutableMap.copyOf(variantMaps.variantsByTarget);
        return null;
    }

    private void apply(ReloadState state, ProfilerFiller profiler) {
        profiler.m_7242_();
        profiler.m_6180_("upload");
        VariantModelBakery modelBakery = state.modelBakery;
        this.variantModels = modelBakery.getBakedTopLevelModels();
        LightmansCurrency.LogInfo("Loaded " + modelBakery.getBakedModelCount() + " variant models for " + this.variantModels.size() + " possible variant states!");
        profiler.m_7238_();
        profiler.m_7241_();
    }

    private void debugModelResults() {
        StringBuilder modelList = new StringBuilder();
        this.variantModels.keySet().forEach(modelID -> modelList.append('\n').append(modelID));
        LightmansCurrency.LogDebug("Model List:" + modelList);
    }

    private static ReloadState loadModels(ProfilerFiller profilerFiller, Map<ResourceLocation, AtlasSet.StitchResult> atlasPreparations, VariantModelBakery modelBakery) {
        profilerFiller.m_6180_("load");
        profilerFiller.m_6182_("baking");
        HashMultimap multimap = HashMultimap.create();
        modelBakery.bakeModels((arg_0, arg_1) -> ModelVariantDataManager.lambda$loadModels$23(atlasPreparations, (Multimap)multimap, arg_0, arg_1));
        multimap.asMap().forEach((id, materials) -> LightmansCurrency.LogWarning(String.format("Missing textures in model %s:\n%s", id, materials.stream().sorted(Material.f_244523_).map(m -> "    " + m.m_119193_() + ":" + m.m_119203_()).collect(Collectors.joining("\n")))));
        profilerFiller.m_6182_("dispatch");
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf((CompletableFuture[])atlasPreparations.values().stream().map(AtlasSet.StitchResult::m_246362_).toArray(CompletableFuture[]::new));
        profilerFiller.m_7238_();
        profilerFiller.m_7241_();
        return new ReloadState(modelBakery, atlasPreparations, completableFuture);
    }

    private static /* synthetic */ TextureAtlasSprite lambda$loadModels$23(Map atlasPreparations, Multimap multimap, String id, Material material) {
        AtlasSet.StitchResult result = (AtlasSet.StitchResult)atlasPreparations.get(material.m_119193_());
        TextureAtlasSprite sprite = result.m_245551_(material.m_119203_());
        if (sprite != null) {
            return sprite;
        }
        multimap.put((Object)id, (Object)material);
        return result.m_247223_();
    }

    private static /* synthetic */ ReloadState lambda$reload$4(ProfilerFiller reloadProfiler, Map atlasLoading, CompletableFuture modelBakeryFuture, Void v) {
        return ModelVariantDataManager.loadModels(reloadProfiler, atlasLoading.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (AtlasSet.StitchResult)((CompletableFuture)e.getValue()).join())), (VariantModelBakery)modelBakeryFuture.join());
    }

    private record VariantMaps(Map<ResourceLocation, ModelVariant> variantMap, Map<ResourceLocation, List<ResourceLocation>> variantsByTarget) {
    }

    record ReloadState(VariantModelBakery modelBakery, Map<ResourceLocation, AtlasSet.StitchResult> atlasPreparations, CompletableFuture<Void> readyForUpload) {
    }
}

