/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util.text_inputs;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IWidgetWrapper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.components.EditBox;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TextBoxWrapper<T>
extends EasyWidget
implements IWidgetWrapper {
    private final EditBox editBox;
    private final Function<String, T> reader;
    private final Function<T, String> writer;

    protected TextBoxWrapper(Builder<T> builder) {
        super(builder);
        this.editBox = builder.box;
        this.reader = builder.reader;
        this.writer = builder.writer;
    }

    public EditBox getWrappedWidget() {
        return this.editBox;
    }

    public void setStringValue(String value) {
        this.editBox.m_94144_(value);
    }

    public void setValue(T value) {
        this.editBox.m_94144_(this.writer.apply(value));
    }

    public static <T> Builder<T> builder(EditBox box, Function<String, T> reader, Function<T, String> writer) {
        return new Builder<T>(box, reader, writer);
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        return false;
    }

    @Override
    protected void renderWidget(EasyGuiGraphics gui) {
    }

    @Override
    protected void renderTick() {
        this.editBox.f_93624_ = this.isVisible();
        this.editBox.f_93623_ = this.f_93623_;
        this.editBox.m_264152_(this.m_252754_(), this.m_252907_());
    }

    public T getValue() {
        return this.reader.apply(this.editBox.m_94155_());
    }

    public static final class Builder<T>
    extends EasyWidget.EasyBuilder<Builder<T>> {
        private final EditBox box;
        private final Function<String, T> reader;
        private final Function<T, String> writer;

        private Builder(EditBox box, Function<String, T> reader, Function<T, String> writer) {
            this.box = box;
            this.reader = reader;
            this.writer = writer;
            this.position(this.box.m_252754_(), this.box.m_252907_());
            this.changeSize(this.box.m_5711_(), this.box.m_93694_());
        }

        @Override
        protected Builder<T> getSelf() {
            return this;
        }

        public TextBoxWrapper<T> build() {
            return new TextBoxWrapper(this);
        }
    }
}

