/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks;

import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CoinBlock
extends FallingBlock {
    public CoinBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean isFullBlock() {
        return true;
    }

    @Nonnull
    public VoxelShape m_7952_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        if (this.isFullBlock()) {
            return super.m_7952_(state, level, pos);
        }
        return Shapes.m_83040_();
    }

    protected SoundEvent getBreakingSound() {
        return ModSounds.COINS_CLINKING.get();
    }

    public void m_48792_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState fallingState, @Nonnull BlockState hitState, @Nonnull FallingBlockEntity fallingBlock) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            LootTable lootTable = this.getLootTable(level, fallingState);
            if (lootTable != null) {
                LootParams params = new LootParams.Builder(sl).m_287235_(LootContextParamSets.f_81410_);
                for (ItemStack item : lootTable.m_287195_(params)) {
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)item);
                }
            }
            level.m_5594_(null, pos, this.getBreakingSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Nullable
    protected LootTable getLootTable(@Nonnull Level level, @Nonnull BlockState state) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.m_278653_().m_278676_(this.getLootTableLocation(state));
        }
        return null;
    }

    @Nonnull
    protected ResourceLocation getLootTableLocation(@Nonnull BlockState state) {
        ResourceLocation blockID = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        return blockID.m_246208_("blocks/falling/");
    }
}

