/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.durability.DurabilityData;
import io.github.lightman314.lightmanscurrency.common.crafting.input.TicketStationRecipeInput;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TicketRecipe
implements TicketStationRecipe {
    private final ResourceLocation id;
    private final Ingredient masterIngredient;
    private final Ingredient ingredient;
    private final Item ticketResult;
    private final DurabilityData durability;

    public Ingredient getMasterIngredient() {
        return this.masterIngredient;
    }

    public TicketRecipe(ResourceLocation id, Ingredient masterIngredient, Ingredient ingredient, Item result, Optional<DurabilityData> durabilityData) {
        this(id, masterIngredient, ingredient, result, durabilityData.orElse(DurabilityData.NULL));
    }

    public TicketRecipe(ResourceLocation id, Ingredient masterIngredient, Ingredient ingredient, Item result, DurabilityData durability) {
        this.id = id;
        this.masterIngredient = masterIngredient;
        this.ingredient = ingredient;
        this.ticketResult = result;
        this.durability = durability;
    }

    @Override
    public List<ItemStack> jeiModifierList() {
        return TicketStationRecipe.exampleTicketList(this.masterIngredient);
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public ItemStack exampleResult() {
        return new ItemStack((ItemLike)this.ticketResult);
    }

    @Override
    public boolean consumeModifier() {
        return false;
    }

    @Override
    public boolean validModifier(ItemStack stack) {
        return this.masterIngredient.test(stack);
    }

    @Override
    public boolean validIngredient(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    @Override
    public DurabilityData getDurabilityData() {
        return this.durability;
    }

    public ItemStack assemble(TicketStationRecipeInput container, RegistryAccess registryAccess) {
        return this.applyDurability(TicketItem.CraftTicket(container.m_8020_(0), this.ticketResult), container.data);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        if (this.masterIngredient.m_43908_().length == 0) {
            return ItemStack.f_41583_;
        }
        return TicketItem.CraftTicket(TicketItem.CreateTicket(this.masterIngredient.m_43908_()[0].m_41720_(), -1L), this.ticketResult);
    }

    @Override
    public ItemStack peekAtResult(Container container, TicketStationRecipe.ExtraData data) {
        return this.applyDurability(TicketItem.CraftTicket(container.m_8020_(0), this.ticketResult), data);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public ItemStack assembleWithKiosk(ItemStack sellItem, TicketStationRecipe.ExtraData data) {
        return this.applyDurability(TicketItem.CraftTicket(sellItem, this.ticketResult), data);
    }

    private ItemStack applyDurability(ItemStack ticket, TicketStationRecipe.ExtraData data) {
        if (this.durability.isValid() && data.durability() > 0 && this.durability.test(data.durability())) {
            TicketItem.setUseCount(ticket, data.durability());
        }
        return ticket;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.TICKET.get();
    }

    public static class Serializer
    implements RecipeSerializer<TicketRecipe> {
        public TicketRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient masterIngredient = Ingredient.m_43917_((JsonElement)json.get("masterTicket"));
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            Item item = CraftingHelper.getItem((String)GsonHelper.m_13906_((JsonObject)json, (String)"result"), (boolean)true);
            Optional<DurabilityData> durability = DurabilityData.parse(json, "durability");
            return new TicketRecipe(id, masterIngredient, ingredient, item, durability);
        }

        @Nullable
        public TicketRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            return new TicketRecipe(id, Ingredient.m_43940_((FriendlyByteBuf)buffer), Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130267_().m_41720_(), DurabilityData.decode(buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer, TicketRecipe recipe) {
            recipe.masterIngredient.m_43923_(buffer);
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(new ItemStack((ItemLike)recipe.ticketResult));
            recipe.durability.encode(buffer);
        }
    }
}

