/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.data.types;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.ejection.SafeEjectionAPI;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class EjectionDataCache
extends CustomData {
    public static final CustomDataType<EjectionDataCache> TYPE = new CustomDataType<EjectionDataCache>("lightmanscurrency_ejection_data", EjectionDataCache::new);
    private long nextID = 0L;
    private final Map<Long, EjectionData> data = new HashMap<Long, EjectionData>();

    private long getNextID() {
        long val = this.nextID++;
        this.setChanged();
        return val;
    }

    private EjectionDataCache() {
    }

    @Override
    public CustomDataType<?> getType() {
        return TYPE;
    }

    @Override
    public void save(CompoundTag tag) {
        tag.m_128356_("NextID", this.nextID);
        ListTag list = new ListTag();
        this.data.forEach((id, e) -> {
            CompoundTag entry = e.save();
            entry.m_128356_("ID", id.longValue());
            list.add((Object)entry);
        });
        tag.m_128365_("EmergencyEjectionData", (Tag)list);
    }

    @Override
    protected void load(CompoundTag tag) {
        if (tag.m_128441_("NextID")) {
            this.nextID = tag.m_128454_("NextID");
        }
        ListTag ejectionData = tag.m_128437_("EmergencyEjectionData", 10);
        for (int i = 0; i < ejectionData.size(); ++i) {
            try {
                CompoundTag data = ejectionData.m_128728_(i);
                EjectionData e = SafeEjectionAPI.getApi().parseData(data);
                if (e != null && !e.isEmpty()) {
                    if (e.id() < 0L) {
                        e.setID(this.nextID++);
                    }
                    this.data.put(e.id(), e);
                    continue;
                }
                LightmansCurrency.LogWarning("Loaded " + (e == null ? "null" : "empty") + " Ejection Data from file!\n" + data.m_7916_());
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading ejection data entry " + i, t);
            }
        }
    }

    public List<EjectionData> getData() {
        return new ArrayList<EjectionData>(this.data.values());
    }

    public void handleEjection(Level level, BlockPos pos, EjectionData data) {
        Objects.requireNonNull(data);
        if (data.isEmpty()) {
            return;
        }
        if (((Boolean)LCConfig.SERVER.safelyEjectMachineContents.get()).booleanValue() && !((Boolean)LCConfig.SERVER.anarchyMode.get()).booleanValue()) {
            long id = this.getNextID();
            data.setID(id);
            this.data.put(id, data);
            this.markEjectionDataDirty(id);
        } else {
            if (data.canSplit() && ((Boolean)LCConfig.SERVER.anarchyMode.get()).booleanValue()) {
                data.splitContents();
            }
            InventoryUtil.dumpContents(level, pos, data.getContents());
        }
        data.pushNotificationToOwner();
    }

    public void markEjectionDataDirty(long id) {
        this.setChanged();
        if (this.data.containsKey(id)) {
            EjectionData data = this.data.get(id);
            if (data.isEmpty()) {
                this.data.remove(id);
                this.sendSyncPacket(this.builder().setLong("RemoveData", id));
            } else {
                this.sendSyncPacket(this.builder().setCompound("UpdateData", data.save()));
            }
        } else {
            this.sendSyncPacket(this.builder().setLong("RemoveData", id));
        }
    }

    @Override
    protected void parseSyncPacket(LazyPacketData message) {
        EjectionData d;
        if (message.contains("RemoveData")) {
            this.data.remove(message.getLong("RemoveData"));
        }
        if (message.contains("UpdateData") && (d = SafeEjectionAPI.getApi().parseData(message.getNBT("UpdateData"))) != null) {
            this.data.put(d.id(), d.flagAsClient(this));
        }
    }

    @Override
    public void onPlayerJoin(ServerPlayer player) {
        for (EjectionData d : this.data.values()) {
            this.sendSyncPacket(this.builder().setCompound("UpdateData", d.save()), player);
        }
    }
}

