/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.data.types;

import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class TeamDataCache
extends CustomData {
    public static final CustomDataType<TeamDataCache> TYPE = new CustomDataType<TeamDataCache>("lightmanscurrency_team_data", TeamDataCache::new);
    private long nextID = 0L;
    private final Map<Long, Team> teams = new HashMap<Long, Team>();

    private long getNextID() {
        long id = this.nextID++;
        this.setChanged();
        return id;
    }

    private TeamDataCache() {
    }

    @Override
    public CustomDataType<?> getType() {
        return TYPE;
    }

    @Override
    public void save(CompoundTag tag) {
        tag.m_128356_("NextID", this.nextID);
        ListTag teamList = new ListTag();
        this.teams.forEach((teamID, team) -> {
            if (team != null) {
                teamList.add((Object)team.save());
            }
        });
        tag.m_128365_("Teams", (Tag)teamList);
    }

    @Override
    protected void load(CompoundTag tag) {
        this.nextID = tag.m_128454_("NextID");
        ListTag teamList = tag.m_128437_("Teams", 10);
        for (int i = 0; i < teamList.size(); ++i) {
            Team team = Team.load(teamList.m_128728_(i));
            if (team == null) continue;
            this.teams.put(team.getID(), team);
        }
    }

    public List<ITeam> getAllTeams() {
        return new ArrayList<ITeam>(this.teams.values());
    }

    @Nullable
    public ITeam getTeam(long teamID) {
        return this.teams.get(teamID);
    }

    public void markTeamDirty(long teamID) {
        if (this.isClient()) {
            return;
        }
        this.setChanged();
        Team team = this.teams.get(teamID);
        if (team != null) {
            this.sendSyncPacket(this.builder().setCompound("UpdateTeam", team.save()));
        }
    }

    @Nullable
    public ITeam registerTeam(Player owner, String teamName) {
        long teamID = this.getNextID();
        Team newTeam = Team.of(teamID, PlayerReference.of(owner), teamName);
        this.teams.put(teamID, newTeam);
        this.markTeamDirty(teamID);
        return newTeam;
    }

    public void removeTeam(long teamID) {
        if (this.teams.containsKey(teamID)) {
            this.teams.remove(teamID);
            this.setChanged();
            this.sendSyncPacket(this.builder().setLong("DeleteTeam", teamID));
        }
    }

    @Override
    protected void parseSyncPacket(LazyPacketData message) {
        Team team;
        if (message.contains("UpdateTeam") && (team = Team.load(message.getNBT("UpdateTeam"))) != null) {
            this.teams.put(team.getID(), team.flagAsClient(this));
        }
        if (message.contains("DeleteTeam")) {
            this.teams.remove(message.getLong("DeleteTeam"));
        }
    }

    @Override
    public void onPlayerJoin(ServerPlayer player) {
        for (Team team : this.teams.values()) {
            this.sendSyncPacket(this.builder().setCompound("UpdateTeam", team.save()), player);
        }
    }
}

