/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.coins.ICoinLike;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.items.ancient_coins.AncientCoinType;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AncientCoinItem
extends Item
implements ICoinLike {
    public static final ResourceLocation PROPERTY = VersionUtil.lcResource("ancient_coin_type");

    public AncientCoinItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean isCoin(ItemStack stack) {
        return AncientCoinItem.getAncientCoinType(stack) != null;
    }

    @Nullable
    public static AncientCoinType getAncientCoinType(ItemStack item) {
        if (item.m_150930_(ModItems.COIN_ANCIENT.get())) {
            CompoundTag tag = item.m_41783_();
            if (tag == null || !tag.m_128441_("CoinType")) {
                return null;
            }
            return (AncientCoinType)EnumUtil.enumFromString((String)tag.m_128461_("CoinType"), (Enum[])AncientCoinType.values(), null);
        }
        return null;
    }

    public void m_142312_(CompoundTag tag) {
        if (tag.m_128471_("RandomCoin")) {
            return;
        }
        if (!tag.m_128441_("CoinType")) {
            tag.m_128359_("CoinType", AncientCoinType.COPPER.toString());
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128471_("RandomCoin") && entity instanceof Player) {
            Player player = (Player)entity;
            RandomSource random = player.m_217043_();
            while (stack.m_41613_() > 1) {
                stack.m_41774_(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)AncientCoinType.random(random).asItem());
            }
            tag.m_128473_("RandomCoin");
            tag.m_128359_("CoinType", AncientCoinType.random(random).toString());
        }
    }

    public String m_5671_(ItemStack stack) {
        String original = super.m_5524_();
        AncientCoinType type = AncientCoinItem.getAncientCoinType(stack);
        if (type == null) {
            return original;
        }
        return original + "." + type.translationTag();
    }

    public boolean m_41386_(DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        return super.m_41386_(source);
    }

    public void m_7373_(ItemStack stack, @Nullable Level context, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, context, tooltip, flag);
        if (flag.m_7050_()) {
            AncientCoinType type = AncientCoinItem.getAncientCoinType(stack);
            if (type == null) {
                return;
            }
            tooltip.add((Component)LCText.TOOLTIP_ANCIENT_COIN_ADVANCED_TYPE.get(LCText.ANCIENT_COIN_TYPE_LABEL.get(type).get(new Object[0])).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }
}

