/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.menus.validation.EasyMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.network.message.menu.CPacketLazyMenu;
import io.github.lightman314.lightmanscurrency.network.message.menu.SPacketLazyMenu;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public abstract class LazyMessageMenu
extends EasyMenu {
    private Consumer<LazyPacketData> clientHandler;

    protected LazyMessageMenu(MenuType<?> type, int id, Inventory inventory) {
        super(type, id, inventory);
        this.clientHandler = m -> {};
    }

    protected LazyMessageMenu(MenuType<?> type, int id, Inventory inventory, MenuValidator validator) {
        super(type, id, inventory, validator);
        this.clientHandler = m -> {};
    }

    public void addMessageListener(Consumer<LazyPacketData> consumer) {
        this.clientHandler = consumer;
    }

    @Nonnull
    public final LazyPacketData.Builder builder() {
        return LazyPacketData.builder();
    }

    public void SendMessage(@Nonnull LazyPacketData.Builder message) {
        if (this.isClient()) {
            this.SendMessageToServer(message);
        } else {
            this.SendMessageToClient(message);
        }
    }

    public void SendMessageToServer(@Nonnull LazyPacketData.Builder message) {
        if (this.isServer()) {
            return;
        }
        new CPacketLazyMenu(this.f_38840_, message).send();
    }

    public void SendMessageToClient(@Nonnull LazyPacketData.Builder message) {
        if (this.isClient()) {
            return;
        }
        new SPacketLazyMenu(this.f_38840_, message).sendTo(this.player);
    }

    public final void handleMessage(LazyPacketData message) {
        this.HandleMessage(message);
        this.clientHandler.accept(message);
    }

    protected abstract void HandleMessage(@Nonnull LazyPacketData var1);
}

