/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.containers;

import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class NonEmptyContainer
implements Container {
    private List<ItemStack> items;

    public NonEmptyContainer(@Nonnull List<ItemStack> items) {
        this.items = NonEmptyContainer.clean(items);
    }

    public NonEmptyContainer(@Nonnull Container other) {
        this((List<ItemStack>)InventoryUtil.buildList(other));
    }

    public void save(@Nonnull CompoundTag tag, @Nonnull String key) {
        InventoryUtil.saveAllItems(key, tag, this);
    }

    public static NonEmptyContainer load(@Nonnull CompoundTag tag, @Nonnull String key) {
        return new NonEmptyContainer((Container)InventoryUtil.loadAllItems(key, tag, tag.m_128437_(key, 10).size()));
    }

    private static List<ItemStack> clean(@Nonnull List<ItemStack> list) {
        return new ArrayList<ItemStack>(list.stream().filter(s -> !s.m_41619_()).toList());
    }

    private void checkContents() {
        this.items = NonEmptyContainer.clean(this.items);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return this.items.isEmpty() || this.items.stream().allMatch(ItemStack::m_41619_);
    }

    private boolean validSlot(int slot) {
        return slot >= 0 && slot < this.items.size();
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        if (!this.validSlot(slot)) {
            return ItemStack.f_41583_;
        }
        return this.items.get(slot);
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int count) {
        ItemStack item = this.m_8020_(slot);
        ItemStack result = item.m_41620_(count);
        if (item.m_41619_() && this.validSlot(slot)) {
            this.items.remove(slot);
        }
        return result;
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        ItemStack item = this.m_8020_(slot);
        if (this.validSlot(slot)) {
            this.items.remove(slot);
        }
        return item;
    }

    public void m_6836_(int slot, @Nonnull ItemStack item) {
        if (this.validSlot(slot)) {
            this.items.set(slot, item);
        } else {
            this.items.add(item);
        }
    }

    public void m_6596_() {
        this.checkContents();
    }

    public boolean m_6542_(@Nonnull Player player) {
        return true;
    }

    public void m_6211_() {
        this.items = new ArrayList<ItemStack>();
    }
}

