/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money.ancient_money;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.api.money.value.IItemBasedValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.common.items.ancient_coins.AncientCoinType;
import io.github.lightman314.lightmanscurrency.common.money.ancient_money.AncientMoneyType;
import io.github.lightman314.lightmanscurrency.common.money.ancient_money.client.AncientPriceEntry;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class AncientMoneyValue
extends MoneyValue
implements IItemBasedValue {
    public final AncientCoinType type;
    public final long count;

    private AncientMoneyValue(@Nonnull AncientCoinType type, long count) {
        this.type = type;
        this.count = count;
    }

    @Nonnull
    public static MoneyValue of(AncientCoinType type, long count) {
        if (type == null || count <= 0L) {
            return AncientMoneyValue.empty();
        }
        return new AncientMoneyValue(type, count);
    }

    @Override
    @Nonnull
    protected ResourceLocation getType() {
        return AncientMoneyType.TYPE;
    }

    @Override
    @Nonnull
    protected String generateUniqueName() {
        return this.generateCustomUniqueName(this.type.resourceSafeName());
    }

    @Override
    public boolean isEmpty() {
        return this.count <= 0L;
    }

    @Override
    public long getCoreValue() {
        return Math.max(0L, this.count);
    }

    @Override
    public MutableComponent getText(@Nonnull MutableComponent emptyText) {
        if (this.isEmpty()) {
            return emptyText;
        }
        return LCText.ANCIENT_COIN_VALUE_DISPLAY.get(this.getCoreValue(), this.type.initial(), this.type.icon());
    }

    @Override
    public MoneyValue addValue(@Nonnull MoneyValue addedValue) {
        if (addedValue instanceof AncientMoneyValue) {
            AncientMoneyValue other = (AncientMoneyValue)addedValue;
            if (other.type == this.type) {
                return new AncientMoneyValue(this.type, this.count + other.count);
            }
        }
        if (addedValue.isEmpty()) {
            return this;
        }
        return null;
    }

    @Override
    public boolean containsValue(@Nonnull MoneyValue queryValue) {
        if (queryValue instanceof AncientMoneyValue) {
            AncientMoneyValue value = (AncientMoneyValue)queryValue;
            if (value.type == this.type) {
                return value.count <= this.count;
            }
        }
        return queryValue.isEmpty();
    }

    @Override
    public MoneyValue subtractValue(@Nonnull MoneyValue removedValue) {
        if (removedValue instanceof AncientMoneyValue) {
            AncientMoneyValue other = (AncientMoneyValue)removedValue;
            if (other.type == this.type) {
                return AncientMoneyValue.of(this.type, this.count - other.count);
            }
        }
        if (removedValue.isEmpty()) {
            return this;
        }
        return null;
    }

    @Override
    public MoneyValue percentageOfValue(int percentage, boolean roundUp) {
        long partial;
        if (percentage == 100) {
            return this;
        }
        if (percentage == 0) {
            return MoneyValue.free();
        }
        if (this.count <= 0L) {
            return MoneyValue.free();
        }
        long value = this.getCoreValue();
        long newValue = value * (long)MathUtil.clamp(percentage, 0, 1000) / 100L;
        if (roundUp && (partial = value * (long)MathUtil.clamp(percentage, 0, 1000) % 100L) > 0L) {
            ++newValue;
        }
        if (newValue <= 0L) {
            return MoneyValue.free();
        }
        return this.fromCoreValue(newValue);
    }

    @Override
    @Nonnull
    public MoneyValue multiplyValue(double multiplier) {
        return AncientMoneyValue.empty();
    }

    @Override
    @Nonnull
    public List<ItemStack> getAsItemList() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.type.asItem(this.count)});
    }

    @Override
    @Nonnull
    public List<ItemStack> onBlockBroken(@Nonnull OwnerData owner) {
        return this.getAsSeperatedItemList();
    }

    @Override
    @Nonnull
    public MoneyValue getSmallestValue() {
        return AncientMoneyValue.of(this.type, 1L);
    }

    @Override
    public boolean allowInterest() {
        return false;
    }

    @Override
    @Nonnull
    public MoneyValue fromCoreValue(long value) {
        return AncientMoneyValue.of(this.type, value);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag) {
        tag.m_128359_("Coin", this.type.toString());
        tag.m_128356_("Count", this.count);
    }

    public static MoneyValue load(@Nonnull CompoundTag tag) {
        AncientCoinType type = (AncientCoinType)EnumUtil.enumFromString((String)tag.m_128461_("Coin"), (Enum[])AncientCoinType.values(), null);
        long count = tag.m_128454_("Count");
        return AncientMoneyValue.of(type, count);
    }

    @Override
    protected void writeAdditionalToJson(@Nonnull JsonObject json) {
        json.addProperty("Coin", this.type.toString());
        json.addProperty("Count", (Number)this.count);
    }

    public static MoneyValue loadFromJson(@Nonnull JsonObject json) throws JsonSyntaxException {
        String typeString = GsonHelper.m_13906_((JsonObject)json, (String)"Coin");
        AncientCoinType type = (AncientCoinType)EnumUtil.enumFromString((String)typeString, (Enum[])AncientCoinType.values(), null);
        if (type == null) {
            throw new JsonSyntaxException(typeString + " is not a valid CoinType");
        }
        long count = GsonHelper.m_13921_((JsonObject)json, (String)"Count");
        if (count <= 0L) {
            throw new JsonSyntaxException("Count cannot be less than 1");
        }
        return AncientMoneyValue.of(type, count);
    }

    @Override
    @Nonnull
    public DisplayEntry getDisplayEntry(@Nullable List<Component> additionalTooltips, boolean tooltipOverride) {
        return new AncientPriceEntry(this, additionalTooltips, tooltipOverride);
    }
}

