/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.settings.data.LoadContext;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.traders.settings.EasyTraderSettingsNode;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class InputSettingsNode
extends EasyTraderSettingsNode<InputTraderData> {
    public InputSettingsNode(InputTraderData trader) {
        super("input", trader);
    }

    @Override
    public MutableComponent getName() {
        return LCText.DATA_CATEGORY_INPUT_SETTINGS.get(new Object[0]);
    }

    @Override
    protected String getRequiredPermission() {
        return "changeExternalInputs";
    }

    @Override
    public void saveSettings(SavedSettingData.MutableNodeAccess data) {
        for (Direction side : Direction.values()) {
            data.setIntValue(side.toString(), ((InputTraderData)this.trader).getSidedState(side).ordinal());
        }
    }

    @Override
    public void loadSettings(SavedSettingData.NodeAccess data, LoadContext context) {
        for (Direction side : Direction.values()) {
            if (!data.hasIntValue(side.toString())) continue;
            ((InputTraderData)this.trader).setDirectionalState(null, side, (DirectionalSettingsState)EnumUtil.enumFromOrdinal((int)data.getIntValue(side.toString()), (Enum[])DirectionalSettingsState.values(), (Enum)DirectionalSettingsState.NONE));
        }
    }

    @Override
    protected void writeLines(SavedSettingData.NodeAccess data, Consumer<Component> lineWriter) {
        int inputCount = 0;
        int outputCount = 0;
        for (Direction side : Direction.values()) {
            if (!data.hasIntValue(side.toString())) continue;
            DirectionalSettingsState state = (DirectionalSettingsState)EnumUtil.enumFromOrdinal((int)data.getIntValue(side.toString()), (Enum[])DirectionalSettingsState.values(), (Enum)DirectionalSettingsState.NONE);
            if (state.allowsInputs()) {
                ++inputCount;
            }
            if (!state.allowsOutputs()) continue;
            ++outputCount;
        }
        lineWriter.accept((Component)LCText.DATA_ENTRY_INPUT_OUTPUT_SIDES_COUNT.get(inputCount, outputCount));
    }
}

