/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.gacha.tradedata.client;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.display.ItemEntry;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.tradedata.GachaTradeData;
import io.github.lightman314.lightmanscurrency.util.ListUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class GachaTradeButtonRenderer
extends TradeRenderManager<GachaTradeData> {
    public GachaTradeButtonRenderer(GachaTradeData trade) {
        super(trade);
    }

    @Override
    public int tradeButtonWidth(TradeContext context) {
        return 94;
    }

    @Override
    public Optional<ScreenPosition> arrowPosition(TradeContext context) {
        return ScreenPosition.ofOptional(36, 1);
    }

    @Override
    public DisplayData inputDisplayArea(TradeContext context) {
        return new DisplayData(1, 1, 34, 16);
    }

    @Override
    public List<DisplayEntry> getInputDisplays(TradeContext context) {
        return this.lazyPriceDisplayList(context);
    }

    @Override
    public DisplayData outputDisplayArea(TradeContext context) {
        return new DisplayData(59, 1, 34, 16);
    }

    @Override
    public List<DisplayEntry> getOutputDisplays(TradeContext context) {
        List<ItemStack> items = ((GachaTradeData)this.trade).trader.getStorage().getContents();
        if (items.isEmpty()) {
            return ImmutableList.of();
        }
        ItemStack display = ListUtil.randomItemFromList(items, ItemStack.f_41583_);
        return ImmutableList.of((Object)ItemEntry.of(display, this.getItemTooltips(items)));
    }

    private List<Component> getItemTooltips(List<ItemStack> items) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)LCText.TOOLTIP_TRADER_GACHA_CONTENTS_LABEL.get(new Object[0]));
        for (ItemStack item : items) {
            list.add((Component)LCText.TOOLTIP_TRADER_GACHA_CONTENTS.get(item.m_41613_(), item.m_41786_()));
        }
        return list;
    }

    @Override
    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
        if (((GachaTradeData)this.trade).trader.getStorage().isEmpty()) {
            alerts.add(AlertData.warn(LCText.TOOLTIP_OUT_OF_STOCK));
        }
        if (!context.hasFunds(((GachaTradeData)this.trade).getCost(context))) {
            alerts.add(AlertData.warn(LCText.TOOLTIP_CANNOT_AFFORD));
        }
    }
}

