/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EquipmentRestriction
extends ItemTradeRestriction {
    private final EquipmentSlot equipmentType;
    public static final EquipmentRestriction HEAD = new EquipmentRestriction(EquipmentSlot.HEAD);
    public static final EquipmentRestriction CHEST = new EquipmentRestriction(EquipmentSlot.CHEST);
    public static final EquipmentRestriction LEGS = new EquipmentRestriction(EquipmentSlot.LEGS);
    public static final EquipmentRestriction FEET = new EquipmentRestriction(EquipmentSlot.FEET);

    protected EquipmentRestriction(EquipmentSlot type) {
        this.equipmentType = type;
    }

    public EquipmentSlot getEquipmentSlot() {
        return this.equipmentType;
    }

    @Override
    public boolean allowSellItem(ItemStack itemStack) {
        return this.equippable(itemStack);
    }

    @Override
    public Predicate<ItemStack> modifyFilter(Predicate<ItemStack> filter) {
        return item -> this.allowSellItem((ItemStack)item) && filter.test((ItemStack)item);
    }

    @Override
    public boolean allowItemSelectItem(ItemStack itemStack) {
        return this.equippable(itemStack);
    }

    private boolean equippable(ItemStack item) {
        try {
            return item.canEquip(this.equipmentType, (Entity)EquipmentRestriction.safeGetDummyArmorStand()) || this.vanillaEquippable(item);
        }
        catch (Throwable e) {
            return this.vanillaEquippable(item);
        }
    }

    private boolean vanillaEquippable(ItemStack item) {
        try {
            return Mob.m_147233_((ItemStack)item) == this.equipmentType;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error checking vanilla equipment logic!", t);
            return false;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Pair<ResourceLocation, ResourceLocation> getEmptySlotBG() {
        return switch (this.equipmentType) {
            case EquipmentSlot.HEAD -> Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39693_);
            case EquipmentSlot.CHEST -> Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39694_);
            case EquipmentSlot.LEGS -> Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39695_);
            case EquipmentSlot.FEET -> Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39696_);
            case EquipmentSlot.OFFHAND -> Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            default -> null;
        };
    }

    private static ArmorStand safeGetDummyArmorStand() throws Exception {
        return new ArmorStand(LightmansCurrency.getProxy().safeGetDummyLevel(), 0.0, 0.0, 0.0);
    }
}

