/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.client.builders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.RotationHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import org.joml.Vector3f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class ItemPositionBuilder {
    private boolean hasGlobalScale = false;
    private float globalScale = 0.0f;
    private RotationHandler globalRotationType = null;
    private int globalExtraCount = 0;
    private Vector3f globalExtraOffset = null;
    private int globalMinLight = 0;
    private final List<PositionEntryBuilder> entries = new ArrayList<PositionEntryBuilder>();

    private ItemPositionBuilder() {
    }

    public static ItemPositionBuilder builder() {
        return new ItemPositionBuilder();
    }

    public ItemPositionBuilder withGlobalRotationType(RotationHandler rotationType) {
        this.globalRotationType = rotationType;
        return this;
    }

    public ItemPositionBuilder withGlobalScale(float globalScale) {
        this.hasGlobalScale = true;
        this.globalScale = globalScale;
        return this;
    }

    public ItemPositionBuilder withGlobalExtraCount(int extraCount) {
        this.globalExtraCount = extraCount;
        return this;
    }

    public ItemPositionBuilder withGlobalExtraOffset(Vector3f extraOffset) {
        this.globalExtraOffset = extraOffset;
        return this;
    }

    public ItemPositionBuilder withGlobalMinLight(int minLight) {
        this.globalMinLight = minLight;
        return this;
    }

    public PositionEntryBuilder withEntry(Vector3f position) {
        PositionEntryBuilder b = new PositionEntryBuilder(this, position);
        this.entries.add(b);
        return b;
    }

    public ItemPositionBuilder withSimpleEntry(Vector3f position) {
        return this.withEntry(position).back();
    }

    public JsonObject write() {
        JsonObject json = new JsonObject();
        if (this.hasGlobalScale) {
            json.addProperty("Scale", (Number)Float.valueOf(this.globalScale));
        }
        if (this.globalRotationType != null) {
            json.add("RotationType", (JsonElement)this.globalRotationType.write());
        }
        if (this.globalExtraCount > 0) {
            json.addProperty("ExtraCount", (Number)this.globalExtraCount);
        }
        if (this.globalExtraOffset != null) {
            json.addProperty("offsetX", (Number)Float.valueOf(this.globalExtraOffset.x));
            json.addProperty("offsetY", (Number)Float.valueOf(this.globalExtraOffset.y));
            json.addProperty("offsetZ", (Number)Float.valueOf(this.globalExtraOffset.z));
        }
        if (this.globalMinLight > 0) {
            json.addProperty("MinLight", (Number)this.globalMinLight);
        }
        JsonArray entryList = new JsonArray();
        for (PositionEntryBuilder entry : this.entries) {
            JsonObject entryData = new JsonObject();
            JsonObject positionData = new JsonObject();
            positionData.addProperty("x", (Number)Float.valueOf(entry.position.x));
            positionData.addProperty("y", (Number)Float.valueOf(entry.position.y));
            positionData.addProperty("z", (Number)Float.valueOf(entry.position.z));
            if (entry.extraCount > 0) {
                positionData.addProperty("ExtraCount", (Number)entry.extraCount);
                positionData.addProperty("offsetX", (Number)Float.valueOf(entry.extraOffset.x));
                positionData.addProperty("offsetY", (Number)Float.valueOf(entry.extraOffset.y));
                positionData.addProperty("offsetZ", (Number)Float.valueOf(entry.extraOffset.z));
            }
            entryData.add("Position", (JsonElement)positionData);
            if (entry.scale > 0.0f) {
                entryData.addProperty("Scale", (Number)Float.valueOf(entry.scale));
            }
            if (entry.minLight >= 0) {
                entryData.addProperty("MinLight", (Number)entry.minLight);
            }
            if (entry.rotationType != null) {
                entryData.add("RotationType", (JsonElement)entry.rotationType.write());
            }
            entryList.add((JsonElement)entryData);
        }
        json.add("Entries", (JsonElement)entryList);
        return json;
    }

    public static class PositionEntryBuilder {
        private final ItemPositionBuilder parent;
        private final Vector3f position;
        private int extraCount = -1;
        private Vector3f extraOffset = null;
        private float scale = -1.0f;
        private int minLight = -1;
        RotationHandler rotationType = null;

        private PositionEntryBuilder(ItemPositionBuilder parent, Vector3f position) {
            this.parent = parent;
            this.position = position;
        }

        public PositionEntryBuilder withExtraCount(int extraCount) {
            this.extraCount = extraCount;
            return this;
        }

        public PositionEntryBuilder withExtraOffset(Vector3f extraOffset) {
            this.extraOffset = extraOffset;
            return this;
        }

        public PositionEntryBuilder withScale(float scale) {
            this.scale = scale;
            return this;
        }

        public PositionEntryBuilder withMinLight(int minLight) {
            this.minLight = minLight;
            return this;
        }

        public PositionEntryBuilder withRotationType(RotationHandler rotationType) {
            this.rotationType = rotationType;
            return this;
        }

        public ItemPositionBuilder back() {
            return this.parent;
        }
    }
}

