/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.crafting.durability.DurabilityData;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TicketRecipeBuilder
implements RecipeBuilder {
    private Ingredient masterIngredient;
    private final Ingredient ingredient;
    private final Item result;
    private DurabilityData durability = DurabilityData.NULL;
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();

    private TicketRecipeBuilder(@Nonnull Ingredient ingredient, @Nonnull ItemLike result) {
        this.ingredient = ingredient;
        this.result = result.m_5456_();
    }

    public static TicketRecipeBuilder of(@Nonnull TagKey<Item> tag, @Nonnull ItemLike result) {
        return TicketRecipeBuilder.of(Ingredient.m_204132_(tag), result);
    }

    public static TicketRecipeBuilder of(@Nonnull ItemLike item, @Nonnull ItemLike result) {
        return TicketRecipeBuilder.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), result);
    }

    public static TicketRecipeBuilder of(@Nonnull Ingredient ingredient, @Nonnull ItemLike result) {
        return new TicketRecipeBuilder(ingredient, result);
    }

    @Nonnull
    public TicketRecipeBuilder withMasterTicket(@Nonnull TagKey<Item> tag) {
        this.masterIngredient = Ingredient.m_204132_(tag);
        return this;
    }

    @Nonnull
    public TicketRecipeBuilder withMasterTicket(@Nonnull ItemLike item) {
        this.masterIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
        return this;
    }

    @Nonnull
    public TicketRecipeBuilder withMasterTicket(@Nonnull Ingredient ingredient) {
        this.masterIngredient = ingredient;
        return this;
    }

    public TicketRecipeBuilder withDurabilityRange(int min, int max) {
        return this.withDurabilityRange(false, min, max);
    }

    public TicketRecipeBuilder withDurabilityRange(boolean allowInfinite, int min, int max) {
        this.durability = new DurabilityData(allowInfinite, min, max);
        return this;
    }

    @Nonnull
    public TicketRecipeBuilder unlockedBy(@Nonnull String name, @Nonnull CriterionTriggerInstance criteria) {
        this.advancement.m_138386_(name, criteria);
        return this;
    }

    @Nonnull
    public TicketRecipeBuilder group(@Nullable String group) {
        return this;
    }

    @Nonnull
    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id, this.masterIngredient, this.ingredient, this.result, this.durability, this.advancement, id.m_246208_("recipes/ticket_machine/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
        if (this.ingredient == null) {
            throw new IllegalStateException("No ingredient defined for " + id);
        }
        if (this.masterIngredient == null) {
            throw new IllegalStateException("No master ticket defined for " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient masterIngredient;
        private final Ingredient ingredient;
        private final Item result;
        private final DurabilityData durability;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(@Nonnull ResourceLocation id, @Nonnull Ingredient masterIngredient, @Nonnull Ingredient ingredient, @Nonnull Item result, DurabilityData durability, @Nonnull Advancement.Builder advancement, @Nonnull ResourceLocation advancementId) {
            this.id = id;
            this.masterIngredient = masterIngredient;
            this.ingredient = ingredient;
            this.result = result;
            this.durability = durability;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(@Nonnull JsonObject json) {
            json.add("masterTicket", this.masterIngredient.m_43942_());
            json.add("ingredient", this.ingredient.m_43942_());
            json.addProperty("result", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            if (this.durability.isValid()) {
                json.add("durability", (JsonElement)this.durability.write());
            }
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return ModRecipes.TICKET.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

