/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.bwg;

import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodData;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodDataHelper;
import java.util.function.Supplier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.MapColor;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWoodSet;

public class BWGCustomWoodTypes {
    private static final String MODID = "biomeswevegone";
    public static final WoodType ASPEN = WoodType.builder("aspen", "biomeswevegone").ofName("Aspen").ofColor(MapColor.f_283942_).build();
    public static final WoodType BAOBAB = WoodType.builder("baobab", "biomeswevegone").ofName("Baobab").ofColor(MapColor.f_283919_).build();
    public static final WoodType BLUE_ENCHANTED = WoodType.builder("blue_enchanted", "biomeswevegone").ofName("Blue Enchanted").ofColor(MapColor.f_283743_).build();
    public static final WoodType CIKA = WoodType.builder("cika", "biomeswevegone").ofName("Cika").ofColor(MapColor.f_283919_).build();
    public static final WoodType CYPRESS = WoodType.builder("cypress", "biomeswevegone").ofName("Cypress").ofColor(MapColor.f_283919_).build();
    public static final WoodType EBONY = WoodType.builder("ebony", "biomeswevegone").ofName("Ebony").ofColor(MapColor.f_283927_).build();
    public static final WoodType FIR = WoodType.builder("fir", "biomeswevegone").ofName("Fir").ofColor(MapColor.f_283919_).build();
    public static final WoodType FLORUS = WoodType.builder("florus", "biomeswevegone").ofName("Florus").ofColor(MapColor.f_283784_).build();
    public static final WoodType GREEN_ENCHANTED = WoodType.builder("green_enchanted", "biomeswevegone").ofName("Green Enchanted").ofColor(MapColor.f_283916_).build();
    public static final WoodType HOLLY = WoodType.builder("holly", "biomeswevegone").ofName("Holly").ofColor(MapColor.f_283919_).build();
    public static final WoodType IRONWOOD = WoodType.builder("ironwood", "biomeswevegone").ofName("Ironwood").ofColor(MapColor.f_283818_).build();
    public static final WoodType JACARANDA = WoodType.builder("jacaranda", "biomeswevegone").ofName("Jacaranda").ofColor(MapColor.f_283765_).build();
    public static final WoodType MAHOGANY = WoodType.builder("mahogany", "biomeswevegone").ofName("Mahogany").ofColor(MapColor.f_283765_).build();
    public static final WoodType MAPLE = WoodType.builder("maple", "biomeswevegone").ofName("Maple").ofColor(MapColor.f_283919_).build();
    public static final WoodType PALM = WoodType.builder("palm", "biomeswevegone").ofName("Palm").ofColor(MapColor.f_283919_).build();
    public static final WoodType PINE = WoodType.builder("pine", "biomeswevegone").ofName("Pine").ofColor(MapColor.f_283919_).build();
    public static final WoodType RAINBOW_EUCALYPTUS = WoodType.builder("rainbow_eucalyptus", "biomeswevegone").ofName("Rainbow Eucalyptus").ofColor(MapColor.f_283919_).build();
    public static final WoodType REDWOOD = WoodType.builder("redwood", "biomeswevegone").ofName("Redwood").ofColor(MapColor.f_283913_).build();
    public static final WoodType SAKURA = WoodType.builder("sakura", "biomeswevegone").ofName("Redwood").ofColor(MapColor.f_283913_).build();
    public static final WoodType SKYRIS = WoodType.builder("skyris", "biomeswevegone").ofName("Skyris").ofColor(MapColor.f_283869_).build();
    public static final WoodType WHITE_MANGROVE = WoodType.builder("white_mangrove", "biomeswevegone").ofName("White Mangrove").ofColor(MapColor.f_283919_).build();
    public static final WoodType WILLOW = WoodType.builder("willow", "biomeswevegone").ofName("Willow").ofColor(MapColor.f_283784_).build();
    public static final WoodType WITCH_HAZEL = WoodType.builder("witch_hazel", "biomeswevegone").ofName("Witch Hazel").ofColor(MapColor.f_283784_).build();
    public static final WoodType ZELKOVA = WoodType.builder("zelkova", "biomeswevegone").ofName("Zelkova").ofColor(MapColor.f_283750_).build();
    public static final WoodType IMBUED_BLUE_ENCHANTED = WoodType.builder("imbued_blue_enchanted", "biomeswevegone").ofName("Imbued Blue Enchanted").ofColor(MapColor.f_283743_).withAttributes(WoodType.Attributes.LOG_ONLY).build();
    public static final WoodType IMBUED_GREEN_ENCHANTED = WoodType.builder("imbued_green_enchanted", "biomeswevegone").ofName("Imbued Green Enchanted").ofColor(MapColor.f_283916_).withAttributes(WoodType.Attributes.LOG_ONLY).build();
    public static final WoodType PALO_VERDE = WoodType.builder("palo_verde", "biomeswevegone").ofName("Palo Verde").ofColor(MapColor.f_283784_).withAttributes(WoodType.Attributes.LOG_ONLY).build();

    public static void setupWoodTypes() {
        BWGCustomWoodTypes.setupWoodType(ASPEN, BWGWood.ASPEN);
        BWGCustomWoodTypes.setupWoodType(BAOBAB, BWGWood.BAOBAB);
        BWGCustomWoodTypes.setupWoodType(BLUE_ENCHANTED, BWGWood.BLUE_ENCHANTED);
        BWGCustomWoodTypes.setupWoodType(CIKA, BWGWood.CIKA);
        BWGCustomWoodTypes.setupWoodType(CYPRESS, BWGWood.CYPRESS);
        BWGCustomWoodTypes.setupWoodType(EBONY, BWGWood.EBONY);
        BWGCustomWoodTypes.setupWoodType(FIR, BWGWood.FIR);
        BWGCustomWoodTypes.setupWoodTypeStemmed(FLORUS, BWGWood.FLORUS);
        BWGCustomWoodTypes.setupWoodType(GREEN_ENCHANTED, BWGWood.GREEN_ENCHANTED);
        BWGCustomWoodTypes.setupWoodType(HOLLY, BWGWood.HOLLY);
        BWGCustomWoodTypes.setupWoodType(IRONWOOD, BWGWood.IRONWOOD);
        BWGCustomWoodTypes.setupWoodType(JACARANDA, BWGWood.JACARANDA);
        BWGCustomWoodTypes.setupWoodType(MAHOGANY, BWGWood.MAHOGANY);
        BWGCustomWoodTypes.setupWoodType(MAPLE, BWGWood.MAPLE);
        BWGCustomWoodTypes.setupWoodType(PALM, BWGWood.PALM);
        BWGCustomWoodTypes.setupWoodType(PINE, BWGWood.PINE);
        BWGCustomWoodTypes.setupWoodType(RAINBOW_EUCALYPTUS, BWGWood.RAINBOW_EUCALYPTUS);
        BWGCustomWoodTypes.setupWoodType(REDWOOD, BWGWood.REDWOOD);
        BWGCustomWoodTypes.setupWoodType(SAKURA, BWGWood.SAKURA);
        BWGCustomWoodTypes.setupWoodType(SKYRIS, BWGWood.SKYRIS);
        BWGCustomWoodTypes.setupWoodType(WHITE_MANGROVE, BWGWood.WHITE_MANGROVE);
        BWGCustomWoodTypes.setupWoodType(WILLOW, BWGWood.WILLOW);
        BWGCustomWoodTypes.setupWoodType(WITCH_HAZEL, BWGWood.WITCH_HAZEL);
        BWGCustomWoodTypes.setupWoodType(ZELKOVA, BWGWood.ZELKOVA);
        BWGCustomWoodTypes.setupWoodTypeWithLog(IMBUED_BLUE_ENCHANTED, BWGWood.BLUE_ENCHANTED, BWGWood.IMBUED_BLUE_ENCHANTED_WOOD, BWGCustomWoodTypes.getTexture(BLUE_ENCHANTED, "imbued_wood"), BWGCustomWoodTypes.getTexture(BLUE_ENCHANTED, "log_top"), BWGCustomWoodTypes.getTexture(BLUE_ENCHANTED, "planks"));
        BWGCustomWoodTypes.setupWoodTypeWithLog(IMBUED_GREEN_ENCHANTED, BWGWood.GREEN_ENCHANTED, BWGWood.IMBUED_GREEN_ENCHANTED_WOOD, BWGCustomWoodTypes.getTexture(GREEN_ENCHANTED, "imbued_wood"), BWGCustomWoodTypes.getTexture(GREEN_ENCHANTED, "log_top"), BWGCustomWoodTypes.getTexture(GREEN_ENCHANTED, "planks"));
        WoodDataHelper.register(PALO_VERDE, WoodData.of2((Supplier<? extends ItemLike>)BWGWood.PALO_VERDE_LOG, null, null, BWGCustomWoodTypes.getTexture(PALO_VERDE, "log"), BWGCustomWoodTypes.getTexture(PALO_VERDE, "log_top"), BWGCustomWoodTypes.getTexture(PALO_VERDE, "log")));
    }

    private static void setupWoodType(WoodType type, BWGWoodSet bygType) {
        WoodDataHelper.register(type, WoodData.of2(() -> ((BWGWoodSet)bygType).logstem(), () -> ((BWGWoodSet)bygType).planks(), () -> ((BWGWoodSet)bygType).slab(), BWGCustomWoodTypes.getTexture(type, "log"), BWGCustomWoodTypes.getTexture(type, "log_top"), BWGCustomWoodTypes.getTexture(type, "planks")));
    }

    private static void setupWoodTypeStemmed(WoodType type, BWGWoodSet bygType) {
        WoodDataHelper.register(type, WoodData.of2(() -> ((BWGWoodSet)bygType).logstem(), () -> ((BWGWoodSet)bygType).planks(), () -> ((BWGWoodSet)bygType).slab(), BWGCustomWoodTypes.getTexture(type, "stem"), BWGCustomWoodTypes.getTexture(type, "stem_top"), BWGCustomWoodTypes.getTexture(type, "planks")));
    }

    private static void setupWoodTypeWithLog(WoodType type, BWGWoodSet bygType, Supplier<? extends ItemLike> customLog, String logSideTexture, String logTopTexture, String plankTexture) {
        WoodDataHelper.register(type, WoodData.of2(customLog, () -> ((BWGWoodSet)bygType).planks(), () -> ((BWGWoodSet)bygType).slab(), logSideTexture, logTopTexture, plankTexture));
    }

    private static String getTexture(WoodType type, String texture) {
        return BWGCustomWoodTypes.getTexture(type.id, texture);
    }

    private static String getTexture(String folder, String texture) {
        return "biomeswevegone:block/" + folder + "/" + texture;
    }
}

