/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft;

import dan200.computercraft.api.peripheral.IPeripheral;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface TraderPeripheralSource {
    @Nullable
    public IPeripheral tryCreate(TraderBlockEntity<?> var1);

    @Nullable
    public IPeripheral tryCreate(TraderData var1);

    public static TraderPeripheralSource simple(Function<TraderBlockEntity<?>, IPeripheral> blockSource, Function<TraderData, IPeripheral> dataSource) {
        return new Simple(blockSource, dataSource);
    }

    public static TraderPeripheralSource blockOnly(Function<TraderBlockEntity<?>, IPeripheral> blockSource) {
        return new Simple(blockSource, d -> null);
    }

    public static TraderPeripheralSource dataOnly(Function<TraderData, IPeripheral> dataSource) {
        return new Simple(b -> null, dataSource);
    }

    public static class Simple
    implements TraderPeripheralSource {
        private final Function<TraderBlockEntity<?>, IPeripheral> blockSource;
        private final Function<TraderData, IPeripheral> traderSource;

        private Simple(Function<TraderBlockEntity<?>, IPeripheral> blockSource, Function<TraderData, IPeripheral> traderSource) {
            this.blockSource = blockSource;
            this.traderSource = traderSource;
        }

        @Override
        @Nullable
        public IPeripheral tryCreate(TraderBlockEntity<?> be) {
            return this.blockSource.apply(be);
        }

        @Override
        @Nullable
        public IPeripheral tryCreate(TraderData trader) {
            return this.traderSource.apply(trader);
        }
    }
}

