/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.impactor.money;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.types.CurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.types.IPlayerMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValueParser;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.integration.impactor.money.ImpactorMoneyValue;
import io.github.lightman314.lightmanscurrency.integration.impactor.money.ImpactorPlayerMoneyProvider;
import io.github.lightman314.lightmanscurrency.integration.impactor.money.ImpactorValueParser;
import io.github.lightman314.lightmanscurrency.integration.impactor.money.client.ImpactorMoneyInputHandler;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ImpactorCurrencyType
extends CurrencyType {
    public static final ResourceLocation TYPE = VersionUtil.lcResource("impactor_compat");
    public static final CurrencyType INSTANCE = new ImpactorCurrencyType();

    private ImpactorCurrencyType() {
        super(TYPE);
    }

    @Override
    protected MoneyValue sumValuesInternal(List<MoneyValue> values) {
        BigDecimal result = BigDecimal.ZERO;
        Currency currency = null;
        for (MoneyValue value : values) {
            if (!(value instanceof ImpactorMoneyValue)) continue;
            ImpactorMoneyValue iv = (ImpactorMoneyValue)value;
            if (currency == null) {
                currency = iv.getImpactorCurrency();
                result = result.add(iv.getValue());
                continue;
            }
            if (!iv.getImpactorCurrency().key().equals(currency.key())) continue;
            result = result.add(iv.getValue());
        }
        return ImpactorMoneyValue.of(currency, result);
    }

    @Override
    @Nullable
    public IPlayerMoneyHandler createMoneyHandlerForPlayer(Player player) {
        return new ImpactorPlayerMoneyProvider(player);
    }

    @Override
    @Nullable
    public IMoneyHandler createMoneyHandlerForContainer(Container container, Consumer<ItemStack> overflowHandler, IClientTracker tracker) {
        return null;
    }

    @Override
    public MoneyValue loadMoneyValue(CompoundTag valueTag) {
        return ImpactorMoneyValue.load(valueTag);
    }

    @Override
    public MoneyValue loadMoneyValueJson(JsonObject json) {
        return ImpactorMoneyValue.load(json);
    }

    @Override
    public MoneyValueParser getValueParser() {
        return ImpactorValueParser.INSTANCE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getInputHandlers(@Nullable Player player) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Currency currency : EconomyService.instance().currencies().registered()) {
            result.add(new ImpactorMoneyInputHandler(currency));
        }
        return result;
    }
}

