/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.auction;

import io.github.lightman314.lightmanscurrency.common.blockentity.AuctionStandBlockEntity;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SPacketSyncAuctionStandDisplay
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketSyncAuctionStandDisplay> HANDLER = new H();
    private final List<ItemStack> items;

    public SPacketSyncAuctionStandDisplay(List<ItemStack> items) {
        this.items = InventoryUtil.copyList(items);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.items.size());
        for (ItemStack item : this.items) {
            buffer.m_130055_(item);
        }
    }

    private static class H
    extends CustomPacket.Handler<SPacketSyncAuctionStandDisplay> {
        private H() {
        }

        @Override
        public SPacketSyncAuctionStandDisplay decode(FriendlyByteBuf buffer) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            int count = buffer.readInt();
            for (int i = 0; i < count; ++i) {
                items.add(buffer.m_130267_());
            }
            return new SPacketSyncAuctionStandDisplay(items);
        }

        @Override
        protected void handle(SPacketSyncAuctionStandDisplay message, Player player) {
            AuctionStandBlockEntity.syncItemsFromServer(message.items);
        }
    }
}

