/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.menu.IBankAccountMenu;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CPacketBankInteraction
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketBankInteraction> HANDLER = new H();
    boolean isDeposit;
    MoneyValue amount;

    public CPacketBankInteraction(boolean isDeposit, MoneyValue amount) {
        this.isDeposit = isDeposit;
        this.amount = amount;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isDeposit);
        this.amount.encode(buffer);
    }

    private static final class H
    extends CustomPacket.Handler<CPacketBankInteraction> {
        private H() {
        }

        @Override
        public CPacketBankInteraction decode(FriendlyByteBuf buffer) {
            return new CPacketBankInteraction(buffer.readBoolean(), MoneyValue.decode(buffer));
        }

        @Override
        protected void handle(CPacketBankInteraction message, Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof IBankAccountMenu) {
                IBankAccountMenu menu = (IBankAccountMenu)abstractContainerMenu;
                if (message.isDeposit) {
                    BankAPI.getApi().BankDeposit(menu, message.amount);
                } else {
                    BankAPI.getApi().BankWithdraw(menu, message.amount);
                }
                menu.onDepositOrWithdraw();
            }
        }
    }
}

