/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.wallet;

import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CPacketOpenWallet
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketOpenWallet> HANDLER = new H();
    private final int walletStackIndex;

    public CPacketOpenWallet(int walletStackIndex) {
        this.walletStackIndex = walletStackIndex;
    }

    public static void sendEquippedPacket() {
        new CPacketOpenWallet(-1).send();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.walletStackIndex);
    }

    private static class H
    extends CustomPacket.Handler<CPacketOpenWallet> {
        private H() {
        }

        @Override
        public CPacketOpenWallet decode(FriendlyByteBuf buffer) {
            return new CPacketOpenWallet(buffer.readInt());
        }

        @Override
        protected void handle(CPacketOpenWallet message, Player player) {
            WalletMenuBase.SafeOpenWalletMenu(player, message.walletStackIndex);
        }
    }
}

