/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.mojang.authlib.GameProfile;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraftforge.common.capabilities.CapabilityProvider;

public class ItemStackHelper {
    private static final Map<String, ItemStack> skullsByName = new HashMap<String, ItemStack>();
    private static final Map<UUID, ItemStack> skullsById = new HashMap<UUID, ItemStack>();

    public static ItemStack skullForPlayer(@Nonnull String playerName) {
        if (!skullsByName.containsKey(playerName)) {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42680_);
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("SkullOwner", playerName);
            stack.m_41751_(tag);
            skullsByName.put(playerName, stack);
        }
        return skullsByName.get(playerName);
    }

    public static ItemStack skullForPlayer(@Nonnull UUID playerID) {
        if (!skullsById.containsKey(playerID)) {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42680_);
            CompoundTag tag = stack.m_41784_();
            GameProfile profile = new GameProfile(playerID, "");
            SkullBlockEntity.m_155738_((GameProfile)profile, result -> stack.m_41784_().m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)result)));
            skullsById.put(playerID, stack);
        }
        return skullsById.get(playerID);
    }

    public static CompoundTag saveAllItems(String key, CompoundTag tag, NonNullList<ItemStack> list) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = (ItemStack)list.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemCompound = new CompoundTag();
            itemCompound.m_128344_("Slot", (byte)i);
            stack.m_41739_(itemCompound);
            listTag.add((Object)itemCompound);
        }
        tag.m_128365_(key, (Tag)listTag);
        return tag;
    }

    public static void loadAllItems(String key, CompoundTag tag, NonNullList<ItemStack> list) {
        ListTag listTag = tag.m_128437_(key, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag slotCompound = listTag.m_128728_(i);
            int index = slotCompound.m_128445_("Slot") & 0xFF;
            if (index >= list.size()) continue;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)slotCompound);
            if (stack.m_41720_() instanceof TicketItem) {
                TicketItem.GetTicketID(stack);
            }
            list.set(index, (Object)stack);
        }
    }

    public static boolean TagEquals(ItemStack stack1, ItemStack stack2) {
        return ItemStackHelper.compareTag(stack1.m_41783_(), stack2.m_41783_()) && stack1.areCapsCompatible((CapabilityProvider)stack2);
    }

    private static boolean compareTag(@Nullable CompoundTag tag1, @Nullable CompoundTag tag2) {
        if (tag1 != null && tag2 != null) {
            return tag1.equals((Object)tag2);
        }
        return tag1 == null == (tag2 == null);
    }
}

