/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.data;

import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.common.data.ClientCustomDataCache;
import io.github.lightman314.lightmanscurrency.common.data.CustomSaveData;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public final class CustomDataType<T extends CustomData> {
    public final String fileName;
    private final Supplier<T> constructor;
    public final boolean serverOnly;

    public CustomDataType(String fileName, Supplier<T> constructor) {
        this(fileName, constructor, false);
    }

    public CustomDataType(String fileName, Supplier<T> constructor, boolean serverOnly) {
        this.fileName = fileName;
        this.constructor = constructor;
        this.serverOnly = serverOnly;
    }

    public T create() {
        return (T)((CustomData)this.constructor.get());
    }

    @Nullable
    public T get(boolean isClient) {
        return isClient ? ClientCustomDataCache.getData(this) : CustomSaveData.getData(this);
    }

    @Nullable
    public T get(IClientTracker tracker) {
        return this.get(tracker.isClient());
    }

    public T getUnknown() {
        if (this.isLoaded(false)) {
            return this.get(false);
        }
        return this.get(true);
    }

    public boolean isLoaded(boolean isClient) {
        return isClient && !this.serverOnly || CustomSaveData.isLoaded(this);
    }

    public boolean isLoaded(IClientTracker tracker) {
        return this.isLoaded(tracker.isClient());
    }
}

