/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.coins.atm.icons.builtin;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteSource;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.NormalSprite;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.icons.ATMIconData;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.icons.IconType;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.atm.ATMExchangeButton;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SpriteIcon
extends ATMIconData {
    public static final ResourceLocation TYPE_NAME = VersionUtil.lcResource("texture");
    public static final IconType TYPE = IconType.create(TYPE_NAME, SpriteIcon::new);
    private final NormalSprite sprite;

    public SpriteIcon(JsonObject data) throws JsonSyntaxException, ResourceLocationException {
        super(data);
        this.sprite = new NormalSprite(new SpriteSource(VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)data, (String)"texture")), GsonHelper.getAsInt((JsonObject)data, (String)"u"), GsonHelper.getAsInt((JsonObject)data, (String)"v"), GsonHelper.getAsInt((JsonObject)data, (String)"width"), GsonHelper.getAsInt((JsonObject)data, (String)"height"), GsonHelper.getAsInt((JsonObject)data, (String)"textureWidth", (int)256), GsonHelper.getAsInt((JsonObject)data, (String)"textureHeight", (int)256)));
    }

    public SpriteIcon(int xPos, int yPos, NormalSprite sprite) {
        super(xPos, yPos);
        this.sprite = sprite;
    }

    @Override
    protected void saveAdditional(JsonObject data, HolderLookup.Provider lookup) {
        data.addProperty("texture", this.sprite.image.texture().toString());
        data.addProperty("u", (Number)this.sprite.image.u());
        data.addProperty("v", (Number)this.sprite.image.v());
        data.addProperty("width", (Number)this.sprite.image.width());
        data.addProperty("height", (Number)this.sprite.image.height());
        data.addProperty("textureWidth", (Number)this.sprite.image.textureWidth());
        data.addProperty("textureHeight", (Number)this.sprite.image.textureHeight());
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE_NAME;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(ATMExchangeButton button, EasyGuiGraphics gui, boolean isHovered) {
        this.sprite.render(gui, this.xPos, this.yPos);
    }
}

