/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.value.builtin;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.CoinEntry;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public final class CoinValuePair {
    public final Item coin;
    public final int amount;

    public ItemStack asStack() {
        return new ItemStack((ItemLike)this.coin, this.amount);
    }

    public CoinValuePair addAmount(int amount) {
        return new CoinValuePair(this.coin, this.amount + amount);
    }

    public CoinValuePair removeAmount(int amount) {
        return new CoinValuePair(this.coin, this.amount - amount);
    }

    public CoinValuePair(Item coin, int amount) {
        this.coin = coin;
        this.amount = amount;
    }

    public CoinValuePair copy() {
        return new CoinValuePair(this.coin, this.amount);
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.putString("Coin", BuiltInRegistries.ITEM.getKey((Object)this.coin).toString());
        tag.putInt("Amount", this.amount);
        return tag;
    }

    public static CoinValuePair load(@Nullable ChainData chainData, @Nonnull CompoundTag tag) {
        return CoinValuePair.from(chainData, (Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(tag.getString("Coin"))), tag.getInt("Amount"));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("Coin", BuiltInRegistries.ITEM.getKey((Object)this.coin).toString());
        json.addProperty("Amount", (Number)this.amount);
        return json;
    }

    @Nullable
    public static CoinValuePair fromJson(@Nonnull ChainData chainData, @Nonnull JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        Item coin = (Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"Coin")));
        int quantity = GsonHelper.getAsInt((JsonObject)json, (String)"Amount", (int)1);
        if (quantity <= 0) {
            throw new JsonSyntaxException("Coin Amount (" + quantity + ") is <= 0!");
        }
        if (CoinAPI.getApi().ChainDataOfCoin(coin) == null) {
            throw new JsonSyntaxException("Coin Item " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)coin)) + " is not a valid coin!");
        }
        return CoinValuePair.from(chainData, coin, quantity);
    }

    @Nullable
    private static CoinValuePair from(@Nullable ChainData chainData, @Nonnull Item coinItem, int amount) {
        if (coinItem == Items.AIR) {
            return null;
        }
        if (chainData == null) {
            return new CoinValuePair(coinItem, amount);
        }
        CoinEntry entry = chainData.findEntry(coinItem);
        if (entry != null) {
            return new CoinValuePair(entry.getCoin(), amount);
        }
        return null;
    }
}

