/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.settings.pretty.builtin;

import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextData;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextWriter;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BookTextWriter
extends PrettyTextWriter {
    public static final PrettyTextWriter INSTANCE = new BookTextWriter();
    public static final int LINES_PER_PAGE = 14;

    private BookTextWriter() {
    }

    @Override
    public boolean worksOnStack(ItemStack stack) {
        return stack.getItem() == Items.WRITTEN_BOOK || InventoryUtil.ItemHasTag(stack, LCTags.Items.SETTINGS_REPLACE_WITH_WRITTEN_BOOK);
    }

    @Override
    public ItemStack writeLinesToStack(@Nullable Player player, ItemStack stack, PrettyTextData data) {
        ItemStack copyStack = stack.transmuteCopy((ItemLike)Items.WRITTEN_BOOK);
        String titleString = data.machineName().getString();
        if (titleString.length() > 32) {
            titleString = LCText.DATA_NAME_BACKUP.get(new Object[0]).getString(32);
        }
        Filterable title = Filterable.passThrough((Object)titleString);
        String author = player != null ? player.getGameProfile().getName() : LCText.GUI_OWNER_NULL.get(new Object[0]).getString();
        ArrayList<Filterable> pages = new ArrayList<Filterable>();
        MutableComponent currentPage = null;
        int lines = 0;
        for (Component line : data.lines()) {
            MutableComponent testPage;
            MutableComponent copy = line.copy();
            MutableComponent mutableComponent = testPage = currentPage == null ? copy : currentPage.copy().append("\n").append((Component)copy);
            if (BookTextWriter.pageTooLong((Component)testPage)) {
                pages.add(Filterable.passThrough((Object)currentPage));
                currentPage = copy;
                lines = 1;
                continue;
            }
            currentPage = testPage;
            if (++lines < 14) continue;
            pages.add(Filterable.passThrough((Object)currentPage));
            currentPage = null;
            lines = 0;
        }
        if (lines > 0 && currentPage != null) {
            pages.add(Filterable.passThrough(currentPage));
        }
        WrittenBookContent content = new WrittenBookContent(title, author, 0, pages, false);
        copyStack.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)content);
        return copyStack;
    }

    private static boolean pageTooLong(Component page) {
        return Component.Serializer.toJson((Component)page, (HolderLookup.Provider)LookupHelper.getRegistryAccess()).length() > Short.MAX_VALUE;
    }
}

