/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.settings.builtin.rules;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsNode;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsSubNode;
import io.github.lightman314.lightmanscurrency.api.settings.data.LoadContext;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.traders.rules.ICopySupportingRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class RuleSubNode
extends SettingsSubNode<SettingsNode> {
    private final ITradeRuleHost host;
    private final Predicate<LoadContext> loadable;
    private final Component name;
    private final int index;

    public RuleSubNode(SettingsNode parent, ITradeRuleHost host, Predicate<LoadContext> loadable, Component name) {
        this(parent, host, loadable, name, -1);
    }

    public RuleSubNode(SettingsNode parent, ITradeRuleHost host, Predicate<LoadContext> loadable, Component name, int index) {
        super(parent);
        this.host = host;
        this.loadable = loadable;
        this.name = name;
        this.index = index;
    }

    @Override
    public String getSubKey() {
        return "trade_rules" + (String)(this.index >= 0 ? "_" + this.index : "");
    }

    @Override
    public MutableComponent getName() {
        return this.name.copy();
    }

    @Override
    public boolean allowLoading(LoadContext context) {
        return this.loadable.test(context);
    }

    @Override
    public void saveSettings(SavedSettingData.MutableNodeAccess data) {
        for (TradeRule rule : this.host.getRules()) {
            if (!rule.isActive() || !(rule instanceof ICopySupportingRule)) continue;
            ICopySupportingRule csr = (ICopySupportingRule)((Object)rule);
            SavedSettingData.MutableNodeAccess ruleNode = data.forSubNode(rule.type.type.toString());
            csr.writeSettings(ruleNode);
        }
    }

    @Override
    public void loadSettings(SavedSettingData.NodeAccess data, LoadContext context) {
        for (TradeRule rule : this.host.getRules()) {
            if (!(rule instanceof ICopySupportingRule)) continue;
            ICopySupportingRule csr = (ICopySupportingRule)((Object)rule);
            SavedSettingData.NodeAccess ruleNode = data.forSubNode(rule.type.type.toString());
            if (ruleNode.isEmpty()) {
                rule.setActive(false);
                csr.resetToDefaultState();
                continue;
            }
            rule.setActive(true);
            csr.loadSettings(ruleNode);
        }
    }

    @Override
    public void writeLines(SavedSettingData.NodeAccess data, Consumer<Component> lineWriter) {
        int count = 0;
        for (TradeRule rule : this.host.getRules()) {
            SavedSettingData.NodeAccess ruleNode = data.forSubNode(rule.type.type.toString());
            if (ruleNode.isEmpty()) continue;
            ++count;
        }
        lineWriter.accept((Component)LCText.DATA_ENTRY_RULES_COUNT.get(count));
    }
}

