/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.CustomModelTest;
import io.github.lightman314.lightmanscurrency.common.util.TagUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class CustomModelData {
    List<Pair<CustomModelTest, ModelResourceLocation>> data;

    private CustomModelData(List<Pair<CustomModelTest, ModelResourceLocation>> data) {
        this.data = ImmutableList.copyOf(data);
        if (this.data.isEmpty()) {
            throw new IllegalArgumentException("Data & Tests cannot be empty!");
        }
    }

    @Nullable
    public ModelResourceLocation getCustomModel(@Nullable BlockEntity blockEntity, ItemStack item) {
        for (Pair<CustomModelTest, ModelResourceLocation> pair : this.data) {
            if (!((CustomModelTest)pair.getFirst()).test(blockEntity, item)) continue;
            return (ModelResourceLocation)pair.getSecond();
        }
        return null;
    }

    public JsonObject write() {
        JsonObject json = new JsonObject();
        JsonArray list = new JsonArray();
        for (Pair<CustomModelTest, ModelResourceLocation> pair : this.data) {
            JsonObject entry = new JsonObject();
            entry.add("test", (JsonElement)((CustomModelTest)pair.getFirst()).write());
            entry.addProperty("model", TagUtil.writeModelResource((ModelResourceLocation)pair.getSecond()));
        }
        json.add("custom_model_providers", (JsonElement)list);
        return json;
    }

    public static CustomModelData read(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        JsonArray list = GsonHelper.getAsJsonArray((JsonObject)json, (String)"custom_model_providers");
        if (list.isEmpty()) {
            throw new JsonSyntaxException("custom_model_providers cannot be empty!");
        }
        ArrayList<Pair<CustomModelTest, ModelResourceLocation>> data = new ArrayList<Pair<CustomModelTest, ModelResourceLocation>>();
        for (int i = 0; i < list.size(); ++i) {
            JsonObject entry = GsonHelper.convertToJsonObject((JsonElement)list.get(i), (String)("custom_model_providers[" + i + "]"));
            JsonObject testEntry = GsonHelper.getAsJsonObject((JsonObject)entry, (String)"test");
            CustomModelTest test = CustomModelTest.parse(testEntry);
            ModelResourceLocation model = TagUtil.readModelResource(GsonHelper.getAsString((JsonObject)json, (String)"model"));
            data.add((Pair<CustomModelTest, ModelResourceLocation>)Pair.of((Object)test, (Object)model));
        }
        return new CustomModelData(data);
    }

    public static class Builder {
        private final List<Pair<CustomModelTest, ModelResourceLocation>> data = new ArrayList<Pair<CustomModelTest, ModelResourceLocation>>();

        private Builder() {
        }

        public Builder add(CustomModelTest test, ModelResourceLocation model) {
            this.data.add((Pair<CustomModelTest, ModelResourceLocation>)Pair.of((Object)test, (Object)model));
            return this;
        }

        public CustomModelData build() {
            return new CustomModelData(this.data);
        }
    }
}

