/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.data.types.TraderDataCache;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.network.message.auction.SPacketSyncAuctionStandDisplay;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public class AuctionStandBlockEntity
extends EasyBlockEntity {
    public boolean dropItem = true;
    private static ImmutableList<ItemStack> displayItems = ImmutableList.of((Object)ItemStack.EMPTY);
    private static boolean randomizeNextOpportunity = false;

    public AuctionStandBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.AUCTION_STAND.get(), pos, state);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void serverStart(ServerStartedEvent event) {
        if (AuctionHouseTrader.isEnabled()) {
            AuctionStandBlockEntity.RandomizeDisplayItems();
        }
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (AuctionHouseTrader.isEnabled() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            new SPacketSyncAuctionStandDisplay((List<ItemStack>)displayItems).sendTo(sp);
        }
    }

    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Pre event) {
        if (AuctionHouseTrader.isEnabled() && event.getServer().getTickCount() % 1200 == 0) {
            if (event.hasTime()) {
                AuctionStandBlockEntity.RandomizeDisplayItems();
            } else {
                randomizeNextOpportunity = true;
            }
        } else if (event.hasTime() && randomizeNextOpportunity) {
            randomizeNextOpportunity = false;
            AuctionStandBlockEntity.RandomizeDisplayItems();
        }
    }

    private static void RandomizeDisplayItems() {
        AuctionTradeData trade;
        AuctionHouseTrader ah;
        randomizeNextOpportunity = false;
        TraderDataCache data = TraderDataCache.TYPE.get(false);
        if (data == null) {
            AuctionStandBlockEntity.setDefaultDisplayItem();
            return;
        }
        TraderData trader = data.getAuctionHouse();
        if (trader instanceof AuctionHouseTrader && (ah = (AuctionHouseTrader)trader).getTradeCount() > 0 && (trade = ah.getTrade(new Random().nextInt(ah.getTradeCount()))) != null) {
            AuctionStandBlockEntity.setDisplayItems(trade.getAuctionItems());
            return;
        }
        AuctionStandBlockEntity.setDefaultDisplayItem();
    }

    public static ImmutableList<ItemStack> getDisplayItems() {
        return displayItems;
    }

    private static void setDefaultDisplayItem() {
        AuctionStandBlockEntity.setDisplayItems((List<ItemStack>)ImmutableList.of((Object)new ItemStack((ItemLike)ModItems.TRADING_CORE.get())));
    }

    private static void setDisplayItems(List<ItemStack> items) {
        displayItems = ImmutableList.copyOf(InventoryUtil.copyList(items));
        new SPacketSyncAuctionStandDisplay((List<ItemStack>)displayItems).sendToAll();
    }

    public static void syncItemsFromServer(List<ItemStack> items) {
        displayItems = ImmutableList.copyOf(items);
    }
}

