/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.Block;

public class CoinJarItem
extends BlockItem {
    public CoinJarItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        TooltipItem.addTooltip(tooltip, LCText.TOOLTIP_COIN_JAR);
        List<ItemStack> jarStorage = CoinJarItem.getJarContents(stack);
        if (!jarStorage.isEmpty()) {
            if (flag.hasControlDown()) {
                for (ItemStack coin : jarStorage) {
                    if (coin.getCount() > 1) {
                        tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_CONTENTS_MULTIPLE.get(coin.getCount(), coin.getHoverName()));
                        continue;
                    }
                    tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_CONTENTS_SINGLE.get(coin.getHoverName()));
                }
            } else {
                tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_HOLD_CTRL.get(new Object[0]).withStyle(ChatFormatting.YELLOW));
            }
        }
        if (InventoryUtil.ItemHasTag(stack, (TagKey<Item>)ItemTags.DYEABLE)) {
            tooltip.add((Component)LCText.TOOLTIP_COIN_JAR_COLORED.getWithStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, level, tooltip, flag);
    }

    public boolean canDye(@Nonnull ItemStack stack) {
        return InventoryUtil.ItemHasTag(stack, (TagKey<Item>)ItemTags.DYEABLE);
    }

    public static List<ItemStack> getJarContents(@Nonnull ItemStack stack) {
        if (!(stack.getItem() instanceof CoinJarItem)) {
            return ImmutableList.of();
        }
        if (stack.has(ModDataComponents.COIN_JAR_CONTENTS)) {
            return (List)stack.get(ModDataComponents.COIN_JAR_CONTENTS);
        }
        return ImmutableList.of();
    }

    public static void setJarContents(@Nonnull ItemStack stack, @Nonnull List<ItemStack> jarContents) {
        if (!(stack.getItem() instanceof CoinJarItem)) {
            return;
        }
        if (jarContents.isEmpty()) {
            stack.remove(ModDataComponents.COIN_JAR_CONTENTS);
        }
        stack.set(ModDataComponents.COIN_JAR_CONTENTS, (Object)ImmutableList.copyOf(InventoryUtil.copyList(jarContents)));
    }

    public static int getJarColor(@Nonnull ItemStack stack) {
        CoinJarItem jar;
        Item item = stack.getItem();
        if (!(item instanceof CoinJarItem) || !(jar = (CoinJarItem)item).canDye(stack)) {
            return 0xFFFFFF;
        }
        DyedItemColor c = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        return c == null ? 0xFFFFFF : c.rgb();
    }

    public static void setJarColor(@Nonnull ItemStack stack, int color) {
        block3: {
            block2: {
                Item item = stack.getItem();
                if (!(item instanceof CoinJarItem)) break block2;
                CoinJarItem jar = (CoinJarItem)item;
                if (InventoryUtil.ItemHasTag(stack, (TagKey<Item>)ItemTags.DYEABLE)) break block3;
            }
            return;
        }
        stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, true));
    }
}

