/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.items.data.CouponData;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CouponItem
extends Item
implements IVariantItem {
    public CouponItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (stack.has(ModDataComponents.TICKET_USES)) {
            tooltip.add((Component)LCText.TOOLTIP_TICKET_USES.get(stack.get(ModDataComponents.TICKET_USES)).withStyle(ChatFormatting.GRAY));
        }
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        if (stack.has(ModDataComponents.COUPON_DATA)) {
            CouponData oldData = (CouponData)stack.get(ModDataComponents.COUPON_DATA);
            stack.remove(ModDataComponents.COUPON_DATA);
            stack.set(ModDataComponents.COUPON_CODE, (Object)oldData.code());
            stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(oldData.color(), false));
        }
        if (stack.has(ModDataComponents.TICKET_USES) && (Integer)stack.get(ModDataComponents.TICKET_USES) <= 0) {
            stack.remove(ModDataComponents.TICKET_USES);
        }
        super.verifyComponentsAfterLoad(stack);
    }

    public static int GetCouponCode(ItemStack coupon) {
        return (Integer)coupon.getOrDefault(ModDataComponents.COUPON_CODE, (Object)0);
    }

    public static int GetCouponColor(ItemStack coupon) {
        if (coupon.isEmpty() || !(coupon.getItem() instanceof CouponItem) || !coupon.has(DataComponents.DYED_COLOR)) {
            return 0xFFFFFF;
        }
        return ((DyedItemColor)coupon.get(DataComponents.DYED_COLOR)).rgb();
    }

    public static ItemStack CreateCoupon(Item coupon, String code, int durability) {
        return CouponItem.CreateCoupon(coupon, code, durability, 0xFFFFFF);
    }

    public static ItemStack CreateCoupon(Item coupon, String code, int durability, int color) {
        ItemStack stack = new ItemStack((ItemLike)coupon);
        if (code.length() > 16) {
            code = code.substring(0, 16);
        }
        stack.set(ModDataComponents.COUPON_CODE, (Object)code.hashCode());
        stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, false));
        if (durability > 0) {
            stack.set(ModDataComponents.TICKET_USES, (Object)durability);
        }
        return stack;
    }
}

