/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.data.types.NotificationDataCache;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class NotificationMenu
extends LazyMessageMenu {
    public static final MenuProvider PROVIDER = new Provider();

    public NotificationMenu(int id, Inventory inventory) {
        super(ModMenus.NOTIFICATIONS.get(), id, inventory);
    }

    @Override
    public void HandleMessage(@Nonnull LazyPacketData message) {
        NotificationData data;
        NotificationDataCache d;
        NotificationCategory category;
        if (message.contains("MarkAsRead")) {
            category = NotificationAPI.getApi().LoadCategory(message.getNBT("MarkAsRead"), message.lookup);
            if (category == null) {
                return;
            }
            d = NotificationDataCache.TYPE.get(false);
            if (d == null) {
                return;
            }
            data = d.getNotifications(this.player);
            if (data != null && data.unseenNotification(category)) {
                for (Notification n : data.getNotifications(category)) {
                    if (n.wasSeen()) continue;
                    n.setSeen();
                }
                d.markNotificationsDirty(this.player.getUUID());
            }
        }
        if (message.contains("DeleteNotification")) {
            category = NotificationAPI.getApi().LoadCategory(message.getNBT("Category"), message.lookup);
            if (category == null) {
                return;
            }
            d = NotificationDataCache.TYPE.get(false);
            if (d == null) {
                return;
            }
            data = d.getNotifications(this.player);
            if (data != null) {
                data.deleteNotification(category, message.getInt("DeleteNotification"));
                d.markNotificationsDirty(this.player.getUUID());
            }
        }
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int slot) {
        return ItemStack.EMPTY;
    }

    private static class Provider
    implements EasyMenuProvider {
        private Provider() {
        }

        @Nullable
        public AbstractContainerMenu createMenu(int menuID, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new NotificationMenu(menuID, inventory);
        }
    }
}

