/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.bank;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.salary.SalaryData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.common.util.TagUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SalaryPaymentNotification
extends Notification {
    public static final NotificationType<SalaryPaymentNotification> TYPE = new NotificationType<SalaryPaymentNotification>(VersionUtil.lcResource("bank_salary_payment"), SalaryPaymentNotification::new);
    private Component accountName;
    private Component salaryName;
    private MoneyValue salaryAmount;
    private MoneyValue totalAmount;
    private List<Component> targetAccounts;

    private SalaryPaymentNotification() {
    }

    private SalaryPaymentNotification(Component accountName, Component salaryName, MoneyValue salaryAmount, MoneyValue totalAmount, List<Component> targetAccounts) {
        this.accountName = accountName;
        this.salaryName = salaryName;
        this.salaryAmount = salaryAmount;
        this.totalAmount = totalAmount;
        this.targetAccounts = ImmutableList.copyOf(targetAccounts);
    }

    public static Supplier<Notification> create(IBankAccount account, SalaryData salary, MoneyValue totalAmount, List<BankReference> targets) {
        MutableComponent accountName = account.getName();
        Component salaryName = salary.getName();
        MoneyValue salaryAmount = salary.getSalary();
        List<Component> targetAccounts = targets.stream().map(SalaryPaymentNotification::safeGetName).toList();
        return () -> SalaryPaymentNotification.lambda$create$0((Component)accountName, salaryName, salaryAmount, totalAmount, targetAccounts);
    }

    private static Component safeGetName(BankReference br) {
        IBankAccount account = br.get();
        if (account == null) {
            return EasyText.literal("ERROR");
        }
        return account.getName();
    }

    @Override
    protected NotificationType<?> getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    public List<Component> getMessageLines() {
        List<Component> lines = LCText.NOTIFICATION_BANK_SALARY_PAYMENT.get(this.salaryName, this.salaryAmount.getText(), this.totalAmount.getText(), this.targetAccounts.size());
        MutableComponent entry = EasyText.empty();
        boolean first = true;
        for (Component target : this.targetAccounts) {
            if (!first) {
                entry = entry.append((Component)LCText.GUI_SEPERATOR.get(new Object[0]));
            }
            entry.append(target);
            if (!first) {
                first = true;
                lines.add((Component)entry);
                entry = EasyText.empty();
                continue;
            }
            first = false;
        }
        if (!first) {
            lines.add((Component)entry);
        }
        return lines;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        compound.putString("Name", Component.Serializer.toJson((Component)this.accountName, (HolderLookup.Provider)lookup));
        compound.putString("SalaryName", Component.Serializer.toJson((Component)this.salaryName, (HolderLookup.Provider)lookup));
        compound.put("Salary", (Tag)this.salaryAmount.save());
        compound.put("Total", (Tag)this.totalAmount.save());
        compound.put("Targets", (Tag)TagUtil.writeStringList(this.targetAccounts.stream().map(c -> Component.Serializer.toJson((Component)c, (HolderLookup.Provider)lookup)).toList()));
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        this.accountName = Component.Serializer.fromJson((String)compound.getString("Name"), (HolderLookup.Provider)lookup);
        this.salaryName = Component.Serializer.fromJson((String)compound.getString("SalaryName"), (HolderLookup.Provider)lookup);
        this.salaryAmount = MoneyValue.load(compound.getCompound("Salary"));
        this.totalAmount = MoneyValue.load(compound.getCompound("Total"));
        this.targetAccounts = TagUtil.loadStringList(compound.getList("Targets", 8)).stream().map(s -> Component.Serializer.fromJson((String)s, (HolderLookup.Provider)lookup)).toList();
    }

    @Override
    protected boolean canMerge(Notification other) {
        return false;
    }

    private static /* synthetic */ Notification lambda$create$0(Component accountName, Component salaryName, MoneyValue salaryAmount, MoneyValue totalAmount, List targetAccounts) {
        return new SalaryPaymentNotification(accountName, salaryName, salaryAmount, totalAmount, targetAccounts);
    }
}

