/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.advancements;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.common.advancements.date.DateTrigger;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.common.items.ancient_coins.AncientCoinType;
import io.github.lightman314.lightmanscurrency.common.text.DualTextEntry;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.CustomProfessions;
import io.github.lightman314.lightmanscurrency.datagen.util.EmptyHolder;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.TradeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class LCCurrencyAdvancements
implements AdvancementProvider.AdvancementGenerator {
    public void generate(@Nonnull HolderLookup.Provider lookup, @Nonnull Consumer<AdvancementHolder> consumer, @Nonnull ExistingFileHelper existingFileHelper) {
        AdvancementHolder root = this.save(consumer, Advancement.Builder.advancement().display((ItemLike)ModItems.COIN_GOLD.get(), (Component)LCText.ADVANCEMENT_ROOT.first.get(new Object[0]), (Component)LCText.ADVANCEMENT_ROOT.second.get(new Object[0]), VersionUtil.modResource("lightmanscurrency", "textures/gui/advancements/backgrounds/currency.png"), AdvancementType.TASK, false, false, false).addCriterion("coin", LCCurrencyAdvancements.ezItemTrigger(LCTags.Items.COINS)), "currency/root");
        AdvancementHolder mfp = this.save(consumer, Advancement.Builder.advancement().parent(root).display(LCCurrencyAdvancements.ezDisplay(ModItems.COIN_COPPER, LCText.ADVANCEMENT_MY_FIRST_PENNY)).addCriterion("coin", LCCurrencyAdvancements.ezItemTrigger(LCTags.Items.COINS)), "currency/myfirstpenny");
        AdvancementHolder tc = this.save(consumer, Advancement.Builder.advancement().parent(mfp).display(LCCurrencyAdvancements.ezDisplay(ModItems.TRADING_CORE, LCText.ADVANCEMENT_TRADING_CORE)).addCriterion("trading_core", LCCurrencyAdvancements.ezItemTrigger((ItemLike)ModItems.TRADING_CORE.get())), "currency/trading_core");
        AdvancementHolder trader = this.save(consumer, Advancement.Builder.advancement().parent(tc).display(LCCurrencyAdvancements.ezDisplay((ItemLike)ModBlocks.CARD_DISPLAY.get(WoodType.OAK, Color.RED), LCText.ADVANCEMENT_TRADER)).addCriterion("trader", LCCurrencyAdvancements.ezItemTrigger(LCTags.Items.TRADER)), "currency/trader");
        AdvancementHolder specialTrader = this.save(consumer, Advancement.Builder.advancement().parent(tc).display(LCCurrencyAdvancements.ezDisplay(ModBlocks.ARMOR_DISPLAY, LCText.ADVANCEMENT_SPECIALTY_TRADER)).addCriterion("specialty_trader", LCCurrencyAdvancements.ezItemTrigger(LCTags.Items.TRADER_SPECIALTY)), "currency/specialty_trader");
        AdvancementHolder networkTrader = this.save(consumer, Advancement.Builder.advancement().parent(tc).display(LCCurrencyAdvancements.ezDisplay(ModBlocks.ITEM_NETWORK_TRADER_4, LCText.ADVANCEMENT_NETWORK_TRADER)).addCriterion("network_trader", LCCurrencyAdvancements.ezItemTrigger(LCTags.Items.TRADER_NETWORK)), "currency/network_trader");
        AdvancementHolder traderInterface = this.save(consumer, Advancement.Builder.advancement().parent(networkTrader).display(LCCurrencyAdvancements.ezDisplay(ModBlocks.ITEM_TRADER_INTERFACE, LCText.ADVANCEMENT_TRADER_INTERFACE)).addCriterion("trader_interface", LCCurrencyAdvancements.ezItemTrigger(LCTags.Items.TRADER_INTERFACE)), "currency/trader_interface");
        AdvancementHolder terminal = this.save(consumer, Advancement.Builder.advancement().parent(mfp).display(LCCurrencyAdvancements.ezDisplay(ModBlocks.TERMINAL, LCText.ADVANCEMENT_TERMINAL)).addCriterion("terminal", LCCurrencyAdvancements.ezItemTrigger(LCTags.Items.NETWORK_TERMINAL)), "currency/terminal");
        AdvancementHolder atm = this.save(consumer, Advancement.Builder.advancement().parent(mfp).display(LCCurrencyAdvancements.ezDisplay(ModBlocks.ATM, LCText.ADVANCEMENT_ATM)).addCriterion("atm_block", LCCurrencyAdvancements.ezItemTrigger(LCTags.Items.ATM)), "currency/atm");
        AdvancementHolder bankerVillager = this.save(consumer, Advancement.Builder.advancement().parent(atm).display(LCCurrencyAdvancements.ezDisplay(ModBlocks.COINBLOCK_NETHERITE, LCText.ADVANCEMENT_BANKER_TRADE, AdvancementType.GOAL, true, true, false)).addCriterion("banker_trade", LCCurrencyAdvancements.ezVillagerTrigger(CustomProfessions.BANKER)), "currency/banker_trade");
        AdvancementHolder coinMint = this.save(consumer, Advancement.Builder.advancement().parent(mfp).display(LCCurrencyAdvancements.ezDisplay(ModBlocks.COIN_MINT, LCText.ADVANCEMENT_COIN_MINT)).addCriterion("coin_mint", LCCurrencyAdvancements.ezItemTrigger((ItemLike)ModBlocks.COIN_MINT.get())), "currency/coin_mint");
        AdvancementHolder wallet = this.save(consumer, Advancement.Builder.advancement().parent(mfp).display(LCCurrencyAdvancements.ezDisplay(ModItems.WALLET_COPPER, LCText.ADVANCEMENT_WALLET_CRAFTING)).addCriterion("wallet", LCCurrencyAdvancements.ezItemTrigger(LCTags.Items.WALLET)), "currency/wallet_crafting");
        AdvancementHolder netheriteWallet = this.save(consumer, Advancement.Builder.advancement().parent(wallet).display(LCCurrencyAdvancements.ezDisplay(ModItems.WALLET_NETHERITE, LCText.ADVANCEMENT_NETHERITE_WALLET)).addCriterion("netherite_wallet", LCCurrencyAdvancements.ezItemTrigger((ItemLike)ModItems.WALLET_NETHERITE.get())), "currency/netherite_wallet");
        AdvancementHolder netherStarWallet = this.save(consumer, Advancement.Builder.advancement().parent(netheriteWallet).display(LCCurrencyAdvancements.ezDisplay(ModItems.WALLET_NETHER_STAR, LCText.ADVANCEMENT_NETHER_STAR_WALLET)).addCriterion("nether_star_wallet", LCCurrencyAdvancements.ezItemTrigger((ItemLike)ModItems.WALLET_NETHER_STAR.get())), "currency/nether_star_wallet");
        ItemStack enchantedWalletItem = new ItemStack((ItemLike)ModItems.WALLET_NETHERITE.get());
        ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        EmptyHolder<Enchantment> coinMagnetHolder = new EmptyHolder<Enchantment>(ModEnchantments.COIN_MAGNET);
        enchantments.set(coinMagnetHolder, 3);
        EnchantmentHelper.setEnchantments((ItemStack)enchantedWalletItem, (ItemEnchantments)enchantments.toImmutable());
        AdvancementHolder enchantedWallet = this.save(consumer, Advancement.Builder.advancement().parent(wallet).display(LCCurrencyAdvancements.ezDisplay(enchantedWalletItem, LCText.ADVANCEMENT_ENCHANTED_WALLET, AdvancementType.GOAL, true, true, false)).addCriterion("enchanted_wallet", LCCurrencyAdvancements.ezItemTrigger((ItemPredicate.Builder b) -> b.of(LCTags.Items.WALLET).withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments((List)ImmutableList.of((Object)new EnchantmentPredicate(coinMagnetHolder, MinMaxBounds.Ints.atLeast((int)1))))))), "currency/enchanted_wallet");
        AdvancementHolder cashRegister = this.save(consumer, Advancement.Builder.advancement().parent(mfp).display(LCCurrencyAdvancements.ezDisplay(ModBlocks.CASH_REGISTER, LCText.ADVANCEMENT_CASH_REGISTER)).addCriterion("cash_register", LCCurrencyAdvancements.ezItemTrigger((ItemLike)ModBlocks.CASH_REGISTER.get())), "currency/cash_register");
        AdvancementHolder cashierVilager = this.save(consumer, Advancement.Builder.advancement().parent(cashRegister).display(LCCurrencyAdvancements.ezDisplay((ItemLike)Items.ENCHANTED_BOOK, LCText.ADVANCEMENT_CASHIER_TRADE, AdvancementType.GOAL, true, true, false)).addCriterion("cashier_trade", LCCurrencyAdvancements.ezVillagerTrigger(CustomProfessions.CASHIER)), "currency/cashier_trade");
        AdvancementHolder susJar = this.save(consumer, Advancement.Builder.advancement().parent(mfp).display((ItemLike)ModBlocks.SUS_JAR.get(), (Component)LCText.ADVANCEMENT_JAR_OF_SUS.first.get(new Object[0]), (Component)LCText.ADVANCEMENT_JAR_OF_SUS.second.getWithStyle(ChatFormatting.BOLD), null, AdvancementType.TASK, true, true, true).addCriterion("jar_of_sus", LCCurrencyAdvancements.ezItemTrigger((ItemLike)ModBlocks.SUS_JAR.get())), "currency/jar_of_sus");
        AdvancementHolder ancientCoins = this.save(consumer, Advancement.Builder.advancement().parent(mfp).display(LCCurrencyAdvancements.ezDisplay(AncientCoinType.GOLD.asItem(), LCText.ADVANCEMENT_ANCIENT_COIN, AdvancementType.GOAL, true, true, true)).addCriterion("ancient_coin", LCCurrencyAdvancements.ezItemTrigger((ItemLike)ModItems.COIN_ANCIENT.get())).rewards(AdvancementRewards.Builder.function((ResourceLocation)VersionUtil.lcResource("unlock_ancient_coins"))), "currency/ancient_coin");
        AdvancementHolder chocolateCoins = this.save(consumer, Advancement.Builder.advancement().parent(mfp).display(LCCurrencyAdvancements.ezDisplay(ModItems.COIN_CHOCOLATE_COPPER, LCText.ADVANCEMENT_EVENT_CHOCOLATE, AdvancementType.CHALLENGE, true, false, true)).addCriterion("has_coins", LCCurrencyAdvancements.ezItemTrigger(LCTags.Items.EVENT_COIN_CHOCOLATE)).rewards(AdvancementRewards.Builder.function((ResourceLocation)VersionUtil.lcResource("unlock_chocolate"))), "currency/events/chocolate_coins");
        AdvancementHolder christmas = this.save(consumer, Advancement.Builder.advancement().parent(chocolateCoins).display(LCCurrencyAdvancements.ezDisplay(ModItems.COIN_CHOCOLATE_GOLD, LCText.ADVANCEMENT_EVENT_CHRISTMAS, AdvancementType.TASK, true)).addCriterion("event", LCCurrencyAdvancements.ezEventTrigger(12, 1, 12, 31)), "currency/events/christmas");
        AdvancementHolder valentines = this.save(consumer, Advancement.Builder.advancement().parent(chocolateCoins).display(LCCurrencyAdvancements.ezDisplay(ModItems.COIN_CHOCOLATE_DIAMOND, LCText.ADVANCEMENT_EVENT_VALENTINES, AdvancementType.TASK, true)).addCriterion("event", LCCurrencyAdvancements.ezEventTrigger(2, 13, 2, 15)), "currency/events/valentines");
    }

    private static DisplayInfo ezDisplay(@Nonnull Supplier<? extends ItemLike> icon, @Nonnull String translation) {
        return LCCurrencyAdvancements.ezDisplay(icon, translation, AdvancementType.TASK, false);
    }

    private static DisplayInfo ezDisplay(@Nonnull Supplier<? extends ItemLike> icon, @Nonnull DualTextEntry translation) {
        return LCCurrencyAdvancements.ezDisplay(icon, translation, AdvancementType.TASK, false);
    }

    private static DisplayInfo ezDisplay(@Nonnull ItemLike icon, @Nonnull String translation) {
        return LCCurrencyAdvancements.ezDisplay(icon, translation, AdvancementType.TASK, true, true, false);
    }

    private static DisplayInfo ezDisplay(@Nonnull ItemLike icon, @Nonnull DualTextEntry translation) {
        return LCCurrencyAdvancements.ezDisplay(icon, translation, AdvancementType.TASK, true, true, false);
    }

    private static DisplayInfo ezDisplay(@Nonnull Supplier<? extends ItemLike> icon, @Nonnull String translation, @Nonnull AdvancementType frame, boolean hidden) {
        return LCCurrencyAdvancements.ezDisplay(icon, translation, AdvancementType.TASK, true, true, hidden);
    }

    private static DisplayInfo ezDisplay(@Nonnull Supplier<? extends ItemLike> icon, @Nonnull DualTextEntry translation, @Nonnull AdvancementType frame, boolean hidden) {
        return LCCurrencyAdvancements.ezDisplay(icon, translation, AdvancementType.TASK, true, true, hidden);
    }

    private static DisplayInfo ezDisplay(@Nonnull Supplier<? extends ItemLike> icon, @Nonnull String translation, @Nonnull AdvancementType frame, boolean toast, boolean chat, boolean hidden) {
        return LCCurrencyAdvancements.ezDisplay(icon.get(), translation, frame, toast, chat, hidden);
    }

    private static DisplayInfo ezDisplay(@Nonnull Supplier<? extends ItemLike> icon, @Nonnull DualTextEntry translation, @Nonnull AdvancementType frame, boolean toast, boolean chat, boolean hidden) {
        return LCCurrencyAdvancements.ezDisplay(icon.get(), translation, frame, toast, chat, hidden);
    }

    private static DisplayInfo ezDisplay(@Nonnull ItemLike icon, @Nonnull String translation, @Nonnull AdvancementType frame, boolean toast, boolean chat, boolean hidden) {
        return LCCurrencyAdvancements.ezDisplay(new ItemStack(icon), translation, frame, toast, chat, hidden);
    }

    private static DisplayInfo ezDisplay(@Nonnull ItemLike icon, @Nonnull DualTextEntry translation, @Nonnull AdvancementType frame, boolean toast, boolean chat, boolean hidden) {
        return LCCurrencyAdvancements.ezDisplay(new ItemStack(icon), translation, frame, toast, chat, hidden);
    }

    private static DisplayInfo ezDisplay(@Nonnull ItemStack icon, @Nonnull DualTextEntry translation, @Nonnull AdvancementType frame, boolean toast, boolean chat, boolean hidden) {
        return new DisplayInfo(icon, (Component)translation.first.get(new Object[0]), (Component)translation.second.get(new Object[0]), Optional.empty(), frame, toast, chat, hidden);
    }

    private static DisplayInfo ezDisplay(@Nonnull ItemStack icon, @Nonnull String translation, @Nonnull AdvancementType frame, boolean toast, boolean chat, boolean hidden) {
        return new DisplayInfo(icon, (Component)Component.translatable((String)(translation + ".title")), (Component)Component.translatable((String)(translation + ".description")), Optional.empty(), frame, toast, chat, hidden);
    }

    private static Criterion<?> ezItemTrigger(@Nonnull TagKey<Item> tag) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tag).build()});
    }

    private static Criterion<?> ezItemTrigger(ItemLike ... items) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items);
    }

    private static Criterion<?> ezItemTrigger(@Nonnull Consumer<ItemPredicate.Builder> consumer) {
        ItemPredicate.Builder builder = ItemPredicate.Builder.item();
        consumer.accept(builder);
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{builder.build()});
    }

    private static Criterion<?> ezVillagerTrigger(@Nonnull Supplier<VillagerProfession> profession) {
        return LCCurrencyAdvancements.ezVillagerTrigger(profession.get());
    }

    private static Criterion<?> ezVillagerTrigger(@Nonnull VillagerProfession profession) {
        EntityPredicate.Builder builder = EntityPredicate.Builder.entity();
        CompoundTag requiredTag = new CompoundTag();
        CompoundTag vilagerData = new CompoundTag();
        vilagerData.putString("profession", BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession).toString());
        requiredTag.put("VillagerData", (Tag)vilagerData);
        builder.nbt(new NbtPredicate(requiredTag));
        return TradeTrigger.TriggerInstance.tradedWithVillager((EntityPredicate.Builder)builder);
    }

    private static Criterion<?> ezEventTrigger(int startMonth, int startDay, int endMonth, int endDay) {
        return DateTrigger.ofRange(startMonth, startDay, endMonth, endDay);
    }

    private AdvancementHolder save(@Nonnull Consumer<AdvancementHolder> consumer, @Nonnull Advancement.Builder builder, @Nonnull String id) {
        AdvancementHolder a = builder.build(VersionUtil.lcResource(id));
        consumer.accept(a);
        return a;
    }
}

