/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.item;

import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.core.util.ArgumentHelpers;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheralMethod;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCArgumentHelper;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.TradeWrapper;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;

public class ItemTradeWrapper<T extends ItemTradeData>
extends TradeWrapper<T> {
    public ItemTradeWrapper(Supplier<T> tradeSource, Supplier<TraderData> trader) {
        super(tradeSource, trader);
    }

    public String getType() {
        return "lc_trade_item";
    }

    public boolean setDirection(IComputerAccess computer, IArguments args) throws LuaException {
        TradeDirection direction = LCArgumentHelper.parseEnum(args, 0, TradeDirection.class);
        if (direction == TradeDirection.OTHER) {
            throw LuaValues.badArgumentOf((IArguments)args, (int)0, (String)"tradedirection");
        }
        ItemTradeData trade = (ItemTradeData)this.getTrade();
        if (this.hasPermission(computer) && trade.getTradeDirection() != direction) {
            trade.setTradeType(direction);
            this.markTradeDirty();
            return true;
        }
        return false;
    }

    public String getRestrictionType() throws LuaException {
        return ItemTradeRestriction.getId(((ItemTradeData)this.getTrade()).getRestriction()).toString();
    }

    public LCLuaTable[] getSellItems() throws LuaException {
        ArrayList<LCLuaTable> list = new ArrayList<LCLuaTable>();
        ItemTradeData trade = (ItemTradeData)this.getTrade();
        for (int i = 0; i < 2; ++i) {
            ItemStack item = trade.getSellItem(i);
            LCLuaTable entry = new LCLuaTable(VanillaDetailRegistries.ITEM_STACK.getBasicDetails((Object)item));
            if (!item.isEmpty()) {
                ItemTradeWrapper.addTradeData(entry, trade, i, trade.getCustomName(i));
            }
            list.add(entry);
        }
        return (LCLuaTable[])list.toArray(LCLuaTable[]::new);
    }

    @Nullable
    public LCLuaTable getSellItemDetails(IArguments args) throws LuaException {
        int slot = args.getInt(0);
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)2, (String)"Slot out of range (%s)");
        ItemTradeData trade = (ItemTradeData)this.getTrade();
        ItemStack item = trade.getSellItem(slot - 1);
        LCLuaTable entry = new LCLuaTable(VanillaDetailRegistries.ITEM_STACK.getDetails((Object)item));
        if (!item.isEmpty()) {
            ItemTradeWrapper.addTradeData(entry, trade, slot - 1, trade.getCustomName(slot - 1));
        }
        return entry;
    }

    public boolean setSellItem(IComputerAccess computer, IArguments args) throws LuaException {
        int slot = args.getInt(0);
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)2, (String)"Slot out of range (%s)");
        ItemStack newItem = LCArgumentHelper.parseItem(args, 1);
        Optional count = args.optInt(2);
        if (count.isPresent()) {
            int c = (Integer)count.get();
            ArgumentHelpers.assertBetween((int)c, (int)1, (int)newItem.getMaxStackSize(), (String)"Item count out of range (%s)");
            newItem.setCount(c);
        }
        ItemTradeData trade = (ItemTradeData)this.getTrade();
        if (this.hasPermission(computer)) {
            trade.setItem(newItem, slot - 1);
            this.markTradeDirty();
            return true;
        }
        return false;
    }

    public LCLuaTable[] getBarterItems() throws LuaException {
        ArrayList<LCLuaTable> list = new ArrayList<LCLuaTable>();
        ItemTradeData trade = (ItemTradeData)this.getTrade();
        if (!trade.isBarter()) {
            return (LCLuaTable[])list.toArray(LCLuaTable[]::new);
        }
        for (int i = 0; i < 2; ++i) {
            ItemStack item = trade.getBarterItem(i);
            LCLuaTable entry = LCLuaTable.fromTag(InventoryUtil.saveItemNoLimits(item, this.registryAccess()));
            if (!item.isEmpty()) {
                ItemTradeWrapper.addTradeData(entry, trade, i + 2, "");
            }
            list.add(entry);
        }
        return (LCLuaTable[])list.toArray(LCLuaTable[]::new);
    }

    public LCLuaTable getBarterItemDetails(IArguments args) throws LuaException {
        int slot = args.getInt(0);
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)2, (String)"Slot out of range (%s)");
        ItemTradeData trade = (ItemTradeData)this.getTrade();
        ItemStack item = trade.getBarterItem(slot - 1);
        LCLuaTable entry = new LCLuaTable(VanillaDetailRegistries.ITEM_STACK.getDetails((Object)item));
        if (!item.isEmpty()) {
            ItemTradeWrapper.addTradeData(entry, trade, slot + 1, "");
        }
        return entry;
    }

    public boolean setBarterItem(IComputerAccess computer, IArguments args) throws LuaException {
        int slot = args.getInt(0);
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)2, (String)"Slot out of range (%s)");
        ItemStack newItem = LCArgumentHelper.parseItem(args, 1);
        Optional count = args.optInt(2);
        if (count.isPresent()) {
            int c = (Integer)count.get();
            ArgumentHelpers.assertBetween((int)c, (int)1, (int)newItem.getMaxStackSize(), (String)"Item count out of range (%s)");
            newItem.setCount(c);
        }
        ItemTradeData trade = (ItemTradeData)this.getTrade();
        if (this.hasPermission(computer)) {
            trade.setItem(newItem, slot + 1);
            this.markTradeDirty();
            return true;
        }
        return false;
    }

    public boolean setEnforceNBT(IComputerAccess computer, IArguments args) throws LuaException {
        int slot = args.getInt(0);
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)4, (String)"Slot out of range (%s)");
        boolean newState = args.getBoolean(1);
        ItemTradeData trade = (ItemTradeData)this.getTrade();
        if (this.hasPermission(computer) && trade.getEnforceNBT(slot - 1) != newState) {
            trade.setEnforceNBT(slot - 1, newState);
            this.markTradeDirty();
            return true;
        }
        return false;
    }

    private static void addTradeData(LCLuaTable table, ItemTradeData trade, int slot, String customName) {
        table.put("EnforceNBT", trade.getEnforceNBT(slot));
        if (!customName.isEmpty()) {
            table.put("CustomName", customName);
        }
    }

    @Override
    protected void registerMethods(LCPeripheralMethod.Registration registration) {
        super.registerMethods(registration);
        registration.register(LCPeripheralMethod.builder("setDirection").withContext(this::setDirection));
        registration.register(LCPeripheralMethod.builder("getRestrictionType").simple(this::getRestrictionType));
        registration.register(LCPeripheralMethod.builder("getSellItems").simpleArray(this::getSellItems));
        registration.register(LCPeripheralMethod.builder("getSellItemDetails").withArgs(this::getSellItemDetails));
        registration.register(LCPeripheralMethod.builder("setSellItem").withContext(this::setSellItem));
        registration.register(LCPeripheralMethod.builder("getBarterItems").simpleArray(this::getBarterItems));
        registration.register(LCPeripheralMethod.builder("getBarterItemDetails").withArgs(this::getBarterItemDetails));
        registration.register(LCPeripheralMethod.builder("setBarterItem").withContext(this::setBarterItem));
        registration.register(LCPeripheralMethod.builder("setEnforceNBT").withContext(this::setEnforceNBT));
    }
}

