/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.slot_machine;

import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.core.util.ArgumentHelpers;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.traders.attachments.builtin.ExternalAuthorizationAttachment;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.integration.computercraft.AccessTrackingPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheralMethod;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCArgumentHelper;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class SlotMachineEntryWrapper
extends AccessTrackingPeripheral {
    private final Supplier<SlotMachineEntry> entrySource;
    private final Supplier<SlotMachineTraderData> traderSource;

    public SlotMachineEntryWrapper(Supplier<SlotMachineEntry> entry, Supplier<SlotMachineTraderData> trader) {
        this.entrySource = entry;
        this.traderSource = trader;
    }

    public String getType() {
        return "lc_slot_machine_entry";
    }

    public final SlotMachineEntry getEntry() throws LuaException {
        SlotMachineEntry entry = this.entrySource.get();
        if (entry == null) {
            throw new LuaException("An unexpected error occurred trying to access the entry!");
        }
        return entry;
    }

    public int getPermissionLevel(IComputerAccess computer) {
        String id = this.getComputerID(computer);
        if (id == null) {
            return 0;
        }
        SlotMachineTraderData trader = this.traderSource.get();
        if (trader == null || !trader.hasAttachment(ExternalAuthorizationAttachment.TYPE)) {
            return 0;
        }
        if (trader.getBlockedPermissions().contains("editTrades")) {
            return 0;
        }
        ExternalAuthorizationAttachment.AccessLevel access = trader.getAttachment(ExternalAuthorizationAttachment.TYPE).getAccessLevel(id);
        return switch (access) {
            default -> throw new MatchException(null, null);
            case ExternalAuthorizationAttachment.AccessLevel.NONE -> 0;
            case ExternalAuthorizationAttachment.AccessLevel.ALLY -> trader.getAllyPermissionMap().getOrDefault("editTrades", 0);
            case ExternalAuthorizationAttachment.AccessLevel.ADMIN -> Integer.MAX_VALUE;
        };
    }

    public boolean hasPermission(IComputerAccess computer) {
        return this.getPermissionLevel(computer) > 0;
    }

    public final void markEntryDirty() {
        SlotMachineTraderData trader = this.traderSource.get();
        if (trader != null) {
            trader.markEntriesDirty();
        }
    }

    public boolean isValid() {
        try {
            return this.getEntry().isValid();
        }
        catch (LuaException exception) {
            return false;
        }
    }

    public LCLuaTable[] getItems() throws LuaException {
        ArrayList<LCLuaTable> list = new ArrayList<LCLuaTable>();
        SlotMachineEntry entry = this.getEntry();
        for (ItemStack item : entry.items) {
            list.add(new LCLuaTable(VanillaDetailRegistries.ITEM_STACK.getBasicDetails((Object)item)));
        }
        return (LCLuaTable[])list.toArray(LCLuaTable[]::new);
    }

    public LCLuaTable getItemDetails(IArguments args) throws LuaException {
        int slot = args.getInt(0);
        SlotMachineEntry entry = this.getEntry();
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)entry.items.size(), (String)"Slot out of range (%s)");
        ItemStack item = entry.items.get(slot - 1);
        return new LCLuaTable(VanillaDetailRegistries.ITEM_STACK.getDetails((Object)item));
    }

    public boolean addItem(IComputerAccess computer, IArguments args) throws LuaException {
        ItemStack item = LCArgumentHelper.parseItem(args, 0);
        SlotMachineEntry entry = this.getEntry();
        if (entry.items.size() >= 4) {
            return false;
        }
        if (this.hasPermission(computer)) {
            entry.TryAddItem(item);
            this.markEntryDirty();
            return true;
        }
        return false;
    }

    public boolean removeItem(IComputerAccess computer, IArguments args) throws LuaException {
        int slot = args.getInt(0);
        SlotMachineEntry entry = this.getEntry();
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)entry.items.size(), (String)"Slot out of range (%s)");
        if (this.hasPermission(computer)) {
            entry.items.remove(slot - 1);
            this.markEntryDirty();
            return true;
        }
        return false;
    }

    public boolean editItem(IComputerAccess computer, IArguments args) throws LuaException {
        int slot = args.getInt(0);
        ItemStack item = LCArgumentHelper.parseItem(args, 0);
        SlotMachineEntry entry = this.getEntry();
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)entry.items.size(), (String)"Slot out of range (%s)");
        if (this.hasPermission(computer)) {
            entry.items.set(slot - 1, item);
            this.markEntryDirty();
            return true;
        }
        return false;
    }

    public boolean isMoney() throws LuaException {
        return this.getEntry().isMoney();
    }

    public LCLuaTable getMoneyValue() throws LuaException {
        return LCLuaTable.fromMoney(this.getEntry().getMoneyValue());
    }

    public double getOdds() throws LuaException {
        return this.getEntry().getOdds();
    }

    public boolean setOdds(IComputerAccess computer, IArguments args) throws LuaException {
        double newOdds = args.getDouble(0);
        ArgumentHelpers.assertBetween((double)newOdds, (double)0.01, (double)99.99, (String)"Odds out of range (%s)");
        SlotMachineEntry entry = this.getEntry();
        if (this.hasPermission(computer)) {
            entry.setOdds(newOdds);
            this.markEntryDirty();
            return true;
        }
        return false;
    }

    public boolean hasCustomIcons() throws LuaException {
        return this.getEntry().hasCustomIcons();
    }

    public boolean setHasCustomIcons(IComputerAccess computer, IArguments args) throws LuaException {
        boolean newState = args.getBoolean(0);
        SlotMachineEntry entry = this.getEntry();
        if (this.hasPermission(computer)) {
            entry.setHasCustomIcons(newState);
            this.markEntryDirty();
            return true;
        }
        return false;
    }

    public LCLuaTable[] getCustomIcons() throws LuaException {
        ArrayList<LCLuaTable> list = new ArrayList<LCLuaTable>();
        SlotMachineEntry entry = this.getEntry();
        for (IconData icon : entry.getCustomIcons()) {
            list.add(LCLuaTable.fromTag(icon.save(this.registryAccess())));
        }
        return (LCLuaTable[])list.toArray(LCLuaTable[]::new);
    }

    public boolean setCustomIcon(IComputerAccess computer, IArguments args) throws LuaException {
        int slot = args.getInt(0);
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)4, (String)"Slot out of range (%s)");
        CompoundTag tag = LCLuaTable.toTag(args.getTable(1));
        IconData icon = IconData.load(tag, this.registryAccess());
        if (icon == null) {
            throw new LuaException("Error parsing icon data");
        }
        SlotMachineEntry entry = this.getEntry();
        if (this.hasPermission(computer)) {
            entry.setCustomIcon(slot - 1, icon);
            this.markEntryDirty();
            return true;
        }
        return false;
    }

    @Override
    protected void registerMethods(LCPeripheralMethod.Registration registration) {
        registration.register(LCPeripheralMethod.builder("isValid").simple(this::isValid));
        registration.register(LCPeripheralMethod.builder("getItems").simpleArray(this::getItems));
        registration.register(LCPeripheralMethod.builder("getItemDetails").withArgs(this::getItemDetails));
        registration.register(LCPeripheralMethod.builder("addItem").withContext(this::addItem));
        registration.register(LCPeripheralMethod.builder("removeItem").withContext(this::removeItem));
        registration.register(LCPeripheralMethod.builder("editItem").withContext(this::editItem));
        registration.register(LCPeripheralMethod.builder("isMoney").simple(this::isMoney));
        registration.register(LCPeripheralMethod.builder("getMoneyValue").simple(this::getMoneyValue));
        registration.register(LCPeripheralMethod.builder("getOdds").simple(this::getOdds));
        registration.register(LCPeripheralMethod.builder("setOdds").withContext(this::setOdds));
        registration.register(LCPeripheralMethod.builder("hasCustomIcons").simple(this::hasCustomIcons));
        registration.register(LCPeripheralMethod.builder("setHasCustomIcons").withContext(this::setHasCustomIcons));
        registration.register(LCPeripheralMethod.builder("getCustomIcons").simpleArray(this::getCustomIcons));
        registration.register(LCPeripheralMethod.builder("setCustomIcon").withContext(this::setCustomIcon));
    }
}

