/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.jade.providers;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperties;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin.TooltipInfo;
import io.github.lightman314.lightmanscurrency.common.blockentity.variant.IVariantSupportingBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ui.ItemStackElement;

public class VariantComponentProvider
implements IBlockComponentProvider {
    public static final ResourceLocation ID = VersionUtil.lcResource("model_variant");
    public static final ResourceLocation LOCKED_CONFIG = VersionUtil.lcResource("model_variant.locked");
    public static final VariantComponentProvider INSTANCE = new VariantComponentProvider();

    private VariantComponentProvider() {
    }

    @Nullable
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        IVariantSupportingBlockEntity be;
        ResourceLocation variant;
        BlockEntity blockEntity;
        IVariantBlock block = VariantProvider.getVariantBlock(accessor.getBlock());
        if (block != null && (blockEntity = accessor.getBlockEntity()) instanceof IVariantSupportingBlockEntity && (variant = (be = (IVariantSupportingBlockEntity)blockEntity).getCurrentVariant()) != null) {
            ItemStack item = new ItemStack((ItemLike)accessor.getBlock());
            item.set(ModDataComponents.MODEL_VARIANT, (Object)variant);
            return ItemStackElement.of((ItemStack)item);
        }
        return super.getIcon((Accessor)accessor, config, currentIcon);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity;
        IVariantBlock block = VariantProvider.getVariantBlock(accessor.getBlock());
        if (block != null && (blockEntity = accessor.getBlockEntity()) instanceof IVariantSupportingBlockEntity) {
            ModelVariant variant;
            IVariantSupportingBlockEntity be = (IVariantSupportingBlockEntity)blockEntity;
            ResourceLocation variantID = be.getCurrentVariant();
            if (variantID != null && (variant = ModelVariantDataManager.getVariant(variantID)) != null) {
                tooltip.add((Component)LCText.TOOLTIP_MODEL_VARIANT_NAME.get(variant.getName().withStyle(ChatFormatting.GOLD)).withStyle(ChatFormatting.YELLOW));
                if (variant.has(VariantProperties.TOOLTIP_INFO)) {
                    TooltipInfo extraTooltip = variant.get(VariantProperties.TOOLTIP_INFO);
                    if (extraTooltip.drawOnJade) {
                        tooltip.addAll(extraTooltip.getTooltip());
                    }
                }
            }
            if (be.isVariantLocked() && config.get(LOCKED_CONFIG)) {
                tooltip.add((Component)LCText.TOOLTIP_MODEL_VARIANT_LOCKED.getWithStyle(ChatFormatting.GRAY));
            }
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

