/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.auction;

import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketSubmitBid
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketSubmitBid> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_auction_submit_bid"));
    public static final CustomPacket.Handler<CPacketSubmitBid> HANDLER = new H();
    final long auctionHouseID;
    final int tradeIndex;
    final MoneyValue bidAmount;

    public CPacketSubmitBid(long auctionHouseID, int tradeIndex, MoneyValue bidAmount) {
        super(TYPE);
        this.auctionHouseID = auctionHouseID;
        this.tradeIndex = tradeIndex;
        this.bidAmount = bidAmount;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketSubmitBid message) {
        buffer.writeLong(message.auctionHouseID);
        buffer.writeInt(message.tradeIndex);
        message.bidAmount.encode(buffer);
    }

    private static CPacketSubmitBid decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketSubmitBid(buffer.readLong(), buffer.readInt(), MoneyValue.decode(buffer));
    }

    private static class H
    extends CustomPacket.Handler<CPacketSubmitBid> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketSubmitBid::encode, CPacketSubmitBid::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketSubmitBid message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof TraderMenu) {
                TraderMenu menu = (TraderMenu)abstractContainerMenu;
                TraderData data = TraderAPI.getApi().GetTrader(false, message.auctionHouseID);
                if (data instanceof AuctionHouseTrader) {
                    AuctionHouseTrader ah = (AuctionHouseTrader)data;
                    ah.makeBid(player, menu, message.tradeIndex, message.bidAmount);
                }
            }
        }
    }
}

